/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.helper;

import com.google.common.truth.Truth;
import io.neonbee.internal.helper.FileSystemHelper;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.OpenOptions;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class FileSystemHelperTest {
    private Path tempDir;

    FileSystemHelperTest() {
    }

    @BeforeEach
    void beforeEach() throws IOException {
        this.tempDir = io.neonbee.test.helper.FileSystemHelper.createTempDirectory();
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should read the content from the passed directory path")
    void testReadDir(Vertx vertx, VertxTestContext testContext) {
        Path subDir = this.tempDir.resolve("subDir");
        Path subFile = this.tempDir.resolve("subFile");
        CompositeFuture.all((Future)FileSystemHelper.createDirs((Vertx)vertx, (Path)subDir), (Future)FileSystemHelper.writeFile((Vertx)vertx, (Path)subFile, (Buffer)Buffer.buffer())).compose(v -> FileSystemHelper.readDir((Vertx)vertx, (Path)this.tempDir)).onComplete(testContext.succeeding(dirContent -> {
            testContext.verify(() -> {
                List<Path> tempDirContent = List.of(subFile.toRealPath(new LinkOption[0]), subDir.toRealPath(new LinkOption[0]));
                Truth.assertThat((Iterable)dirContent).containsExactlyElementsIn(tempDirContent);
            });
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should read the content from the passed directory path based on the passed filter query")
    void testReadDirWithFilter(Vertx vertx, VertxTestContext testContext) {
        Path subDir = this.tempDir.resolve("subDir");
        Path subFile = this.tempDir.resolve("subFile.edmx");
        CompositeFuture.all((Future)FileSystemHelper.createDirs((Vertx)vertx, (Path)subDir), (Future)FileSystemHelper.writeFile((Vertx)vertx, (Path)subFile, (Buffer)Buffer.buffer())).compose(v -> FileSystemHelper.readDir((Vertx)vertx, (Path)this.tempDir, (String)"(.+)(\\.edmx$)")).onComplete(testContext.succeeding(dirContent -> {
            testContext.verify(() -> Truth.assertThat((Iterable)dirContent).containsExactly(new Object[]{subFile.toRealPath(new LinkOption[0])}));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should check if the paths are directories")
    void testIfFileIsDir(Vertx vertx, VertxTestContext testContext) {
        Path subFile = this.tempDir.resolve("subFile");
        FileSystemHelper.isDirectory((Vertx)vertx, (Path)this.tempDir).compose(isDir -> {
            Truth.assertThat((Boolean)isDir).isTrue();
            return FileSystemHelper.writeFile((Vertx)vertx, (Path)subFile, (Buffer)Buffer.buffer());
        }).compose(v -> FileSystemHelper.isDirectory((Vertx)vertx, (Path)subFile)).onComplete(testContext.succeeding(isDir -> {
            Truth.assertThat((Boolean)isDir).isFalse();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should open a file")
    void testOpenFile(Vertx vertx, VertxTestContext testContext) throws IOException {
        Path subFile = this.tempDir.resolve("subFile");
        Buffer expectedContent = Buffer.buffer((byte[])"lord citrange".getBytes(StandardCharsets.UTF_8));
        Files.write(subFile, "lord citrange".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Buffer gotBuffer = Buffer.buffer();
        FileSystemHelper.openFile((Vertx)vertx, (OpenOptions)new OpenOptions(), (Path)subFile).compose(asyncFile -> Future.future(promise -> asyncFile.read(gotBuffer, 0, 0L, expectedContent.length(), (Handler)promise))).onComplete(testContext.succeeding(buffer -> testContext.verify(() -> {
            Truth.assertThat((Object)buffer).isEqualTo((Object)expectedContent);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should read a file")
    void testReadFile(Vertx vertx, VertxTestContext testContext) throws IOException {
        Path subFile = this.tempDir.resolve("subFile");
        Buffer expectedContent = Buffer.buffer((byte[])"lord citrange".getBytes(StandardCharsets.UTF_8));
        Files.write(subFile, "lord citrange".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileSystemHelper.readFile((Vertx)vertx, (Path)subFile).onComplete(testContext.succeeding(buffer -> {
            testContext.verify(() -> Truth.assertThat((Object)buffer).isEqualTo((Object)expectedContent));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should write a file")
    void testWriteFile(Vertx vertx, VertxTestContext testContext) {
        Path subFile = this.tempDir.resolve("subFile");
        String expectedContent = "lord citrange";
        FileSystemHelper.writeFile((Vertx)vertx, (Path)subFile, (Buffer)Buffer.buffer((byte[])"lord citrange".getBytes(StandardCharsets.UTF_8))).onComplete(testContext.succeeding(v -> {
            testContext.verify(() -> Truth.assertThat((String)Files.readString(subFile)).isEqualTo((Object)expectedContent));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should delete recursively the content from the passed directory path")
    void testDeleteRecursive(Vertx vertx, VertxTestContext testContext) {
        Path subDir = this.tempDir.resolve("subDir");
        FileSystemHelper.createDirs((Vertx)vertx, (Path)subDir).compose(v -> FileSystemHelper.deleteRecursive((Vertx)vertx, (Path)this.tempDir)).compose(v -> FileSystemHelper.exists((Vertx)vertx, (Path)this.tempDir)).onComplete(testContext.succeeding(isExisting -> {
            Truth.assertThat((Boolean)isExisting).isFalse();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should check if a file exists")
    void testExistsFile(Vertx vertx, VertxTestContext testContext) {
        Path subFile = this.tempDir.resolve("subFile");
        FileSystemHelper.exists((Vertx)vertx, (Path)this.tempDir).compose(isExisting -> {
            Truth.assertThat((Boolean)isExisting).isTrue();
            return FileSystemHelper.exists((Vertx)vertx, (Path)subFile);
        }).onComplete(testContext.succeeding(isExisting -> {
            Truth.assertThat((Boolean)isExisting).isFalse();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should create directories")
    void testCreateDirs(Vertx vertx, VertxTestContext testContext) {
        Path subDir = this.tempDir.resolve("subDir");
        Path subSubDir = subDir.resolve("subSubDir");
        FileSystemHelper.createDirs((Vertx)vertx, (Path)subSubDir).compose(v -> FileSystemHelper.exists((Vertx)vertx, (Path)subSubDir)).onComplete(testContext.succeeding(isExisting -> {
            Truth.assertThat((Boolean)isExisting).isTrue();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test should identify the property of the file")
    void testProps(Vertx vertx, VertxTestContext testContext) {
        FileSystemHelper.getProperties((Vertx)vertx, (Path)this.tempDir).onComplete(testContext.succeeding(property -> {
            Truth.assertThat((Boolean)property.isDirectory()).isTrue();
            testContext.completeNow();
        }));
    }

    @Test
    @DisplayName(value="Parse paths")
    void testParsePaths() {
        Truth.assertThat((Iterable)FileSystemHelper.parsePaths((String[])new String[0])).isEmpty();
        List<Path> expectedPaths = List.of(Path.of("a", new String[0]), Path.of("b", new String[0]), Path.of("c", new String[0]));
        Truth.assertThat((Iterable)FileSystemHelper.parsePaths((String[])new String[]{"a", "b", "c"})).containsExactlyElementsIn(expectedPaths);
        Truth.assertThat((Iterable)FileSystemHelper.parsePaths((String[])new String[]{"a" + File.pathSeparator + "b" + File.pathSeparator + "c"})).containsExactlyElementsIn(expectedPaths);
        Truth.assertThat((Iterable)FileSystemHelper.parsePaths((String[])new String[]{"a" + File.pathSeparator + "b", "c"})).containsExactlyElementsIn(expectedPaths);
        Truth.assertThat((Iterable)FileSystemHelper.parsePaths((String[])new String[]{"a", "b" + File.pathSeparator + "c"})).containsExactlyElementsIn(expectedPaths);
    }

    @Test
    @DisplayName(value="Get path from map")
    void testGetPathFromMap() {
        Truth.assertThat((Boolean)((Boolean)FileSystemHelper.getPathFromMap(Map.of("test/test.txt", true), (String)("test" + File.separator + "test.txt")))).isTrue();
        Truth.assertThat((Boolean)((Boolean)FileSystemHelper.getPathFromMap(Map.of("test\\test.txt", true), (String)("test" + File.separator + "test.txt")))).isTrue();
        Truth.assertThat((Boolean)((Boolean)FileSystemHelper.getPathFromMap(Map.of("test/test.txt", true), (String)"testtest.txt"))).isNull();
    }
}

