/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.hook;

import com.google.common.truth.Truth;
import io.neonbee.hook.HookRegistration;
import io.neonbee.hook.HookRegistry;
import io.neonbee.hook.HookType;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class HookRegistryTest {
    private static final String CORRELATION_ID = "correl";

    HookRegistryTest() {
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that registerHooks instantiate class correct")
    void registerHooksSuccess(final VertxTestContext testContext) {
        TestHookRegistry registry = new TestHookRegistry(){

            @Override
            public Future<Collection<HookRegistration>> registerInstanceHooks(Object instance, String correlationId) {
                testContext.verify(() -> {
                    Truth.assertThat((Object)instance).isInstanceOf(Object.class);
                    Truth.assertThat((String)correlationId).isEqualTo((Object)HookRegistryTest.CORRELATION_ID);
                });
                return Future.succeededFuture();
            }
        };
        registry.registerHooks(Object.class, CORRELATION_ID).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check that registerHooks throw an error if no constructor is available")
    void registerHooksFails(VertxTestContext testContext) throws SecurityException, IllegalArgumentException {
        TestHookRegistry registry = new TestHookRegistry();
        registry.registerHooks(Void.class, CORRELATION_ID).onComplete(testContext.failing(t -> {
            testContext.verify(() -> Truth.assertThat((Throwable)t).isInstanceOf(NoSuchMethodException.class));
            testContext.completeNow();
        }));
    }

    private static class TestHookRegistry
    implements HookRegistry {
        private TestHookRegistry() {
        }

        public Future<Collection<HookRegistration>> registerInstanceHooks(Object instance, String correlationId) {
            return null;
        }

        public Future<Collection<HookRegistration>> getHookRegistrations() {
            return null;
        }

        public CompositeFuture executeHooks(HookType type, Map<String, Object> parameters) {
            return null;
        }
    }
}

