/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import io.neonbee.test.helper.FileSystemHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class BasicJar {
    private final Manifest manifest;
    private final Map<ZipEntry, byte[]> content;

    public BasicJar(Map<String, byte[]> content) {
        this(Map.of(), content);
    }

    public BasicJar(Map<String, String> manifestAttributes, Map<String, byte[]> content) {
        this(BasicJar.createManifest(manifestAttributes), content.entrySet().stream().collect(Collectors.toMap(entry -> new ZipEntry((String)entry.getKey()), Map.Entry::getValue)));
    }

    public BasicJar(Manifest manifest, Map<ZipEntry, byte[]> content) {
        this.manifest = Objects.requireNonNull(manifest);
        this.content = content;
    }

    public void writeToFile(Path destination) throws IOException {
        Files.write(destination, this.createJarFile(), new OpenOption[0]);
    }

    public Path writeToTempPath() throws IOException {
        Path jarPath = FileSystemHelper.createTempDirectory().resolve(UUID.randomUUID().toString());
        this.writeToFile(jarPath);
        return jarPath;
    }

    public URL[] writeToTempURL() throws IOException {
        return new URL[]{this.writeToTempPath().toUri().toURL()};
    }

    private byte[] createJarFile() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (JarOutputStream jos = Objects.isNull(this.manifest) ? new JarOutputStream(baos) : new JarOutputStream((OutputStream)baos, this.manifest);){
                for (Map.Entry<ZipEntry, byte[]> entry : this.content.entrySet()) {
                    jos.putNextEntry(entry.getKey());
                    jos.write(entry.getValue());
                    jos.closeEntry();
                }
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static Manifest createManifest(Map<String, String> attributes) {
        Manifest manifest = new Manifest();
        attributes.forEach((key, value) -> manifest.getMainAttributes().put(new Attributes.Name((String)key), value));
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        return manifest;
    }

    public static String getJarEntryName(String className) {
        return className.replace(".", "/").concat(".class");
    }
}

