/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import io.neonbee.test.helper.FileSystemHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public interface ClassTemplate {
    public String getSimpleName();

    public String getPackageName();

    default public String getClassName() {
        if (Strings.isNullOrEmpty((String)this.getPackageName())) {
            return this.getSimpleName();
        }
        return this.getPackageName() + "." + this.getSimpleName();
    }

    private String resourcePath() {
        return this.getClassName().replace(".", "/") + ".java";
    }

    public String reifyTemplate();

    default public byte[] compileToByteCode() throws IOException {
        Path tempDir = FileSystemHelper.createTempDirectory();
        Path sourceFile = tempDir.resolve(this.resourcePath());
        Files.createDirectories(sourceFile.getParent(), new FileAttribute[0]);
        Files.writeString(sourceFile, (CharSequence)this.reifyTemplate(), new OpenOption[0]);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            throw new RuntimeException("Unable to detect Java compiler, make sure you're using a JDK not a JRE!");
        }
        StandardJavaFileManager standardFileManager = javaCompiler.getStandardFileManager(null, null, null);
        standardFileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.singleton(tempDir.toFile()));
        standardFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(tempDir.toFile()));
        JavaFileObject javaFileToCompile = standardFileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, this.getClassName(), JavaFileObject.Kind.SOURCE);
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = javaCompiler.getTask(null, standardFileManager, diagnostics, null, null, List.of(javaFileToCompile));
        if (!task.call().booleanValue()) {
            String msgs = diagnostics.getDiagnostics().stream().map(d -> d.getMessage(Locale.getDefault())).collect(Collectors.joining("\n"));
            throw new RuntimeException("Compilation Failed: \n" + msgs);
        }
        JavaFileObject compiledClassFile = standardFileManager.getJavaFileForInput(StandardLocation.CLASS_OUTPUT, this.getClassName(), JavaFileObject.Kind.CLASS);
        return ByteStreams.toByteArray((InputStream)compiledClassFile.openInputStream());
    }
}

