/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import io.neonbee.internal.BasicJar;
import io.neonbee.internal.ClassTemplate;
import io.neonbee.internal.DummyVerticleTemplate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class NeonBeeModuleJar
extends BasicJar {
    public static final List<String> DUMMY_VERTICLES = List.of("ClassA", "ClassB");
    public static final Map<String, byte[]> DUMMY_MODELS = Map.of("models/User.csn", "userCsn".getBytes(StandardCharsets.UTF_8), "models/Product.csn", "productCsn".getBytes(StandardCharsets.UTF_8));
    public static final Map<String, byte[]> DUMMY_EXTENSION_MODELS = Map.of("models/User.edmx", "userEdmx".getBytes(StandardCharsets.UTF_8), "models/Product.edmx", "productEdmx".getBytes(StandardCharsets.UTF_8));

    public static NeonBeeModuleJarFactory create(String name) {
        return new NeonBeeModuleJarFactory(name);
    }

    public NeonBeeModuleJar(String name, ClassTemplate ... verticleTemplates) throws IOException {
        this(name, Arrays.asList(verticleTemplates));
    }

    public NeonBeeModuleJar(String name, List<ClassTemplate> verticleTemplates) throws IOException {
        super(NeonBeeModuleJar.createManifest(name, NeonBeeModuleJar.extractIdentifiers(verticleTemplates)), NeonBeeModuleJar.transformToContentMap(verticleTemplates, Map.of(), Map.of()));
    }

    public NeonBeeModuleJar(String name, List<ClassTemplate> verticleTemplates, Map<String, byte[]> models, Map<String, byte[]> extensionModels) throws IOException {
        super(NeonBeeModuleJar.createManifest(name, NeonBeeModuleJar.extractIdentifiers(verticleTemplates), models.keySet(), extensionModels.keySet(), List.of()), NeonBeeModuleJar.transformToContentMap(verticleTemplates, models, extensionModels));
    }

    public static Manifest createManifest(String name, Collection<String> deployables) {
        return NeonBeeModuleJar.createManifest(name, deployables, List.of(), List.of(), List.of());
    }

    public static Manifest createManifest(String name, Collection<String> deployables, Collection<String> modelPaths, Collection<String> extensionModelPaths, Collection<String> hooks) {
        Map<String, String> attributes = Map.of("NeonBee-Module", name, "NeonBee-Deployables", String.join((CharSequence)";", deployables), "NeonBee-Hooks", String.join((CharSequence)";", hooks), "NeonBee-Models", String.join((CharSequence)";", modelPaths), "NeonBee-Model-Extensions", String.join((CharSequence)";", extensionModelPaths));
        return BasicJar.createManifest(attributes);
    }

    private static List<String> extractIdentifiers(List<ClassTemplate> verticleTemplates) {
        return verticleTemplates.stream().map(ClassTemplate::getClassName).collect(Collectors.toList());
    }

    private static Map<ZipEntry, byte[]> transformToContentMap(List<ClassTemplate> verticleTemplates, Map<String, byte[]> models, Map<String, byte[]> extensionModels) throws IOException {
        HashMap<ZipEntry, byte[]> content = new HashMap<ZipEntry, byte[]>(verticleTemplates.size());
        for (ClassTemplate classTemplate : verticleTemplates) {
            content.put(new ZipEntry(NeonBeeModuleJar.getJarEntryName(classTemplate.getClassName())), classTemplate.compileToByteCode());
        }
        for (Map.Entry entry : models.entrySet()) {
            content.put(new ZipEntry((String)entry.getKey()), (byte[])entry.getValue());
        }
        for (Map.Entry entry : extensionModels.entrySet()) {
            content.put(new ZipEntry((String)entry.getKey()), (byte[])entry.getValue());
        }
        return content;
    }

    public static class NeonBeeModuleJarFactory {
        private final String name;
        private final List<ClassTemplate> verticleTemplates = new ArrayList<ClassTemplate>();
        private final Map<String, byte[]> models = new HashMap<String, byte[]>();
        private final Map<String, byte[]> extensionModels = new HashMap<String, byte[]>();

        NeonBeeModuleJarFactory(String name) {
            this.name = name;
        }

        public NeonBeeModuleJarFactory withVerticles() throws IOException {
            return this.withVerticles((String[])DUMMY_VERTICLES.toArray(String[]::new));
        }

        public NeonBeeModuleJarFactory withVerticles(String ... classNames) throws IOException {
            for (String className : classNames) {
                this.addVerticle(new DummyVerticleTemplate(className, "doesn't matter"));
            }
            return this;
        }

        public NeonBeeModuleJarFactory withModels() {
            DUMMY_MODELS.forEach(this::addModel);
            DUMMY_EXTENSION_MODELS.forEach(this::addExtensionModel);
            return this;
        }

        public NeonBeeModuleJarFactory addVerticle(ClassTemplate verticleTemplate) {
            this.verticleTemplates.add(verticleTemplate);
            return this;
        }

        public NeonBeeModuleJarFactory addModel(String name, byte[] content) {
            this.models.put(name, content);
            return this;
        }

        public NeonBeeModuleJarFactory addExtensionModel(String name, byte[] content) {
            this.extensionModels.put(name, content);
            return this;
        }

        public NeonBeeModuleJar build() throws IOException {
            return new NeonBeeModuleJar(this.name, this.verticleTemplates, this.models, this.extensionModels);
        }
    }
}

