/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal;

import com.google.common.truth.Truth;
import io.neonbee.internal.RegexBlockList;
import java.util.regex.Pattern;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class RegexBlockListTest {
    RegexBlockListTest() {
    }

    @Test
    @DisplayName(value="Test if an empty list allows everything")
    void testEmpty() {
        RegexBlockList blockList = new RegexBlockList();
        Truth.assertThat((Boolean)blockList.isAllowed("Abc")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Bcd")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Cde")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Efg")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Fgh")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Ghi")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed(".*")).isTrue();
    }

    @Test
    @DisplayName(value="Test if the list blocks the right entries")
    void testBlockList() {
        RegexBlockList blockList = new RegexBlockList();
        blockList.block("A.*");
        blockList.block("B.*");
        blockList.block(Pattern.compile("C.*"));
        Truth.assertThat((Boolean)blockList.isAllowed("Abc")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Bcd")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Cde")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Efg")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Fgh")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Ghi")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed(".*")).isTrue();
    }

    @Test
    @DisplayName(value="Test if the list allows the right entries")
    void testAllowList() {
        RegexBlockList blockList = new RegexBlockList();
        blockList.allow("A.*");
        blockList.allow("B.*");
        blockList.allow(Pattern.compile("C.*"));
        Truth.assertThat((Boolean)blockList.isAllowed("Abc")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Bcd")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Cde")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Efg")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Fgh")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Ghi")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed(".*")).isFalse();
    }

    @Test
    @DisplayName(value="Test if the list block and allows the right entries")
    void testBlockAllowList() {
        RegexBlockList blockList = new RegexBlockList();
        blockList.block("A.*");
        blockList.allow("AA.*");
        blockList.block("B.*");
        blockList.allow("BB.*");
        blockList.block(Pattern.compile("C.*"));
        blockList.allow(Pattern.compile("CC.*"));
        Truth.assertThat((Boolean)blockList.isAllowed("Abc")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Acb")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("AAx")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Bcd")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Bdc")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("BBx")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Cde")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("Ced")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("CCx")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Efg")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Fgh")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("Ghi")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed(".*")).isTrue();
    }

    @Test
    @DisplayName(value="Test if the list can be cleared")
    void testClear() {
        RegexBlockList blockList = new RegexBlockList();
        blockList.block("A.*");
        blockList.allow("AA.*");
        Truth.assertThat((Boolean)blockList.isAllowed("A")).isFalse();
        Truth.assertThat((Boolean)blockList.isAllowed("AA")).isTrue();
        Truth.assertThat((Boolean)blockList.isAllowed("B")).isTrue();
        blockList.clear();
        Truth.assertThat((Boolean)blockList.isAllowed("A")).isTrue();
    }
}

