/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import com.google.common.truth.Truth;
import io.neonbee.internal.buffer.ImmutableBuffer;
import io.neonbee.internal.codec.ImmutableBufferMessageCodec;
import io.vertx.core.buffer.Buffer;
import org.junit.jupiter.api.Test;

class ImmutableBufferMessageCodecTest {
    private final ImmutableBufferMessageCodec codec = new ImmutableBufferMessageCodec();
    private final ImmutableBuffer immutableBuffer = ImmutableBuffer.buffer((Buffer)Buffer.buffer((String)"testFooBar"));

    ImmutableBufferMessageCodecTest() {
    }

    @Test
    void testEncode() {
        Buffer buffer = Buffer.buffer();
        this.codec.encodeToWire(buffer, this.immutableBuffer);
        ImmutableBuffer decoded = this.codec.decodeFromWire(0, buffer);
        Truth.assertThat((Object)decoded).isEqualTo((Object)this.immutableBuffer);
    }

    @Test
    void testTransform() {
        Truth.assertThat((Object)this.codec.transform(this.immutableBuffer)).isEqualTo((Object)this.immutableBuffer);
        Truth.assertThat((Object)this.codec.transform(this.immutableBuffer)).isSameInstanceAs((Object)this.immutableBuffer);
    }

    @Test
    void testName() {
        Truth.assertThat((String)this.codec.name()).isEqualTo((Object)"immutablebuffer");
    }

    @Test
    void testSystemCodecID() {
        Truth.assertThat((Comparable)Byte.valueOf(this.codec.systemCodecID())).isEqualTo((Object)-1);
    }
}

