/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import com.google.common.truth.Truth;
import io.neonbee.internal.codec.ImmutableJsonArrayMessageCodec;
import io.neonbee.internal.json.ImmutableJsonArray;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.junit.jupiter.api.Test;

class ImmutableJsonArrayMessageCodecTest {
    private final ImmutableJsonArrayMessageCodec codec = new ImmutableJsonArrayMessageCodec();
    private final ImmutableJsonArray jsonArray = new ImmutableJsonArray(new JsonArray().add((Object)"test").add((Object)1).add((Object)new JsonObject().put("foo", (Object)"bar")));

    ImmutableJsonArrayMessageCodecTest() {
    }

    @Test
    void testEncode() {
        Buffer buffer = Buffer.buffer();
        this.codec.encodeToWire(buffer, this.jsonArray);
        ImmutableJsonArray decoded = this.codec.decodeFromWire(0, buffer);
        Truth.assertThat((Iterable)decoded).isEqualTo((Object)this.jsonArray);
    }

    @Test
    void testTransform() {
        Truth.assertThat((Iterable)this.codec.transform(this.jsonArray)).isEqualTo((Object)this.jsonArray);
        Truth.assertThat((Iterable)this.codec.transform(this.jsonArray)).isSameInstanceAs((Object)this.jsonArray);
    }

    @Test
    void testName() {
        Truth.assertThat((String)this.codec.name()).isEqualTo((Object)"immutablejsonarray");
    }

    @Test
    void testSystemCodecID() {
        Truth.assertThat((Comparable)Byte.valueOf(this.codec.systemCodecID())).isEqualTo((Object)-1);
    }
}

