/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import com.google.common.truth.Truth;
import io.neonbee.internal.codec.ImmutableJsonObjectMessageCodec;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.junit.jupiter.api.Test;

class ImmutableJsonObjectMessageCodecTest {
    private final ImmutableJsonObjectMessageCodec codec = new ImmutableJsonObjectMessageCodec();
    private final ImmutableJsonObject jsonObject = new ImmutableJsonObject(new JsonObject().put("foo", (Object)"bar").put("test", (Object)1).put("arr", (Object)new JsonArray().add((Object)"foo").add((Object)"2")));

    ImmutableJsonObjectMessageCodecTest() {
    }

    @Test
    void testEncode() {
        Buffer buffer = Buffer.buffer();
        this.codec.encodeToWire(buffer, this.jsonObject);
        ImmutableJsonObject decoded = this.codec.decodeFromWire(0, buffer);
        Truth.assertThat((Iterable)decoded).isEqualTo((Object)this.jsonObject);
    }

    @Test
    void testTransform() {
        Truth.assertThat((Iterable)this.codec.transform(this.jsonObject)).isEqualTo((Object)this.jsonObject);
        Truth.assertThat((Iterable)this.codec.transform(this.jsonObject)).isSameInstanceAs((Object)this.jsonObject);
    }

    @Test
    void testName() {
        Truth.assertThat((String)this.codec.name()).isEqualTo((Object)"immutablejsonobject");
    }

    @Test
    void testSystemCodecID() {
        Truth.assertThat((Comparable)Byte.valueOf(this.codec.systemCodecID())).isEqualTo((Object)-1);
    }
}

