/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.truth.Correspondence;
import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.internal.NeonBeeModuleJar;
import io.neonbee.internal.deploy.DeployableModels;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.test.helper.ReflectionHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DeployableModelsTest {
    DeployableModelsTest() {
    }

    @Test
    @DisplayName(value="test instantiation")
    void testInstantiation() {
        EntityModelDefinition definition = new EntityModelDefinition(Map.of(), Map.of());
        DeployableModels deployable = new DeployableModels(definition);
        Truth.assertThat((Object)deployable.modelDefinition).isSameInstanceAs((Object)definition);
    }

    @Test
    @DisplayName(value="test getIdentifier")
    void testGetIdentifier() {
        EntityModelDefinition definition = new EntityModelDefinition(Map.of(), Map.of());
        DeployableModels deployable = new DeployableModels(definition);
        Truth.assertThat((String)deployable.getIdentifier()).isEqualTo((Object)definition.toString());
    }

    @Test
    @DisplayName(value="test deploy and undeploy")
    void testDeployUndeploy() throws NoSuchFieldException, IllegalAccessException {
        EntityModelDefinition definition = new EntityModelDefinition(Map.of(), Map.of());
        DeployableModels deployable = new DeployableModels(definition);
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setIgnoreClassPath(true));
        PendingDeployment deployment = deployable.deploy(neonBee);
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Set definitions = (Set)ReflectionHelper.getValueOfPrivateField(neonBee.getModelManager(), "externalModelDefinitions");
        Truth.assertThat((Iterable)definitions).contains((Object)definition);
        Truth.assertThat((Boolean)deployment.undeploy().succeeded()).isTrue();
        Truth.assertThat((Iterable)definitions).doesNotContain((Object)definition);
    }

    @Test
    @DisplayName(value="test deploy failed")
    void testDeployFailed() {
        EntityModelDefinition definition = new EntityModelDefinition(Map.of(), Map.of());
        DeployableModels deployable = new DeployableModels(definition);
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        Mockito.when((Object)vertxMock.fileSystem().readDir((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((String)"any failure"));
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setIgnoreClassPath(true));
        PendingDeployment deployment = deployable.deploy(neonBee);
        Truth.assertThat((Boolean)deployment.failed()).isTrue();
        Truth.assertThat((Throwable)deployment.cause()).hasMessageThat().isEqualTo((Object)"any failure");
        Truth.assertThat((Boolean)deployment.undeploy().succeeded()).isTrue();
    }

    @Test
    @DisplayName(value="test read model payloads")
    void testReadModelPayloads() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        ClassLoader classLoaderMock = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)classLoaderMock.getResourceAsStream((String)ArgumentMatchers.any())).thenAnswer(invocation -> new ByteArrayInputStream(((String)invocation.getArgument(0)).getBytes(StandardCharsets.UTF_8)));
        Future result = DeployableModels.readModelPayloads((Vertx)vertxMock, (ClassLoader)classLoaderMock, List.of("foo", "bar"));
        Truth.assertThat((Boolean)result.succeeded()).isTrue();
        Truth.assertThat(((Map)result.result()).keySet()).containsExactly(new Object[]{"foo", "bar"});
    }

    @Test
    @DisplayName(value="test scan class path")
    void testScanClassPath() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        ClassPathScanner classPathScannerMock = (ClassPathScanner)Mockito.mock(ClassPathScanner.class);
        Mockito.when((Object)classPathScannerMock.scanManifestFiles((Vertx)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture(List.of("entry")));
        ClassLoader classLoaderMock = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)classPathScannerMock.getClassLoader()).thenReturn((Object)classLoaderMock);
        Mockito.when((Object)classLoaderMock.getResourceAsStream((String)ArgumentMatchers.any())).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Future deployable = DeployableModels.scanClassPath((Vertx)vertxMock, (ClassPathScanner)classPathScannerMock);
        Truth.assertThat((Boolean)deployable.succeeded()).isTrue();
        ((ClassPathScanner)Mockito.verify((Object)classPathScannerMock)).scanManifestFiles(vertxMock, "NeonBee-Models");
        ((ClassPathScanner)Mockito.verify((Object)classPathScannerMock)).scanManifestFiles(vertxMock, "NeonBee-Model-Extensions");
        ((ClassLoader)Mockito.verify((Object)classLoaderMock, (VerificationMode)Mockito.times((int)2))).getResourceAsStream("entry");
        EntityModelDefinition definition = ((DeployableModels)deployable.result()).modelDefinition;
        Truth.assertThat(definition.getCSNModelDefinitions().keySet()).containsExactly(new Object[]{"entry"});
        Truth.assertThat(definition.getAssociatedModelDefinitions().keySet()).containsExactly(new Object[]{"entry"});
    }

    @Test
    @DisplayName(value="test from JAR")
    void testFromJar() throws IOException {
        NeonBeeModuleJar moduleJar = NeonBeeModuleJar.create("testmodule").withModels().build();
        Future deployable = DeployableModels.fromJar((Vertx)NeonBeeMockHelper.defaultVertxMock(), (Path)moduleJar.writeToTempPath());
        Truth.assertThat((Boolean)deployable.succeeded()).isTrue();
        Truth.assertThat((Map)((DeployableModels)deployable.result()).modelDefinition.getCSNModelDefinitions()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"is not equal to")).containsExactlyEntriesIn(NeonBeeModuleJar.DUMMY_MODELS);
        Truth.assertThat((Map)((DeployableModels)deployable.result()).modelDefinition.getAssociatedModelDefinitions()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"is not equal to")).containsExactlyEntriesIn(NeonBeeModuleJar.DUMMY_EXTENSION_MODELS);
    }
}

