/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.truth.Correspondence;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.internal.BasicJar;
import io.neonbee.internal.NeonBeeModuleJar;
import io.neonbee.internal.deploy.DeployableModels;
import io.neonbee.internal.deploy.DeployableModule;
import io.neonbee.internal.deploy.DeployableVerticle;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.test.helper.DummyVerticleHelper;
import io.neonbee.test.helper.FileSystemHelper;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.NoStackTraceThrowable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DeployableModuleTest {
    DeployableModuleTest() {
    }

    @Test
    @DisplayName(value="test instantiation")
    void testInstantiation() {
        Assert.assertThrows(NullPointerException.class, () -> new DeployableModule(null, null, null));
        DeployableModule deployable1 = new DeployableModule("moduleA", null, List.of());
        Truth.assertThat((String)deployable1.moduleName).isEqualTo((Object)"moduleA");
        Truth.assertThat((Object)deployable1.moduleClassLoader).isNull();
        URLClassLoader classLoader = (URLClassLoader)Mockito.mock(URLClassLoader.class);
        DeployableModule deployable2 = new DeployableModule("moduleB", classLoader, List.of());
        Truth.assertThat((String)deployable2.moduleName).isEqualTo((Object)"moduleB");
        Truth.assertThat((Object)deployable2.moduleClassLoader).isSameInstanceAs((Object)classLoader);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new DeployableModule("moduleC", null, List.of(new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE, new DeploymentOptions()))));
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"Missing module class loader for provided deployable verticle(s)");
    }

    @Test
    @DisplayName(value="test getIdentifier")
    void testGetIdentifier() {
        Truth.assertThat((String)new DeployableModule("moduleA", null, List.of()).getIdentifier()).isEqualTo((Object)"moduleA");
        Truth.assertThat((String)new DeployableModule("moduleB", null, List.of()).getIdentifier()).isEqualTo((Object)"moduleB");
    }

    @Test
    @DisplayName(value="test getDeployables is unmodifiable (even if the original list was modifiable)")
    void testGetDeployablesIsUnmodifiable() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> new DeployableModule("module", null, new ArrayList()).getDeployables().add(null));
    }

    @Test
    @DisplayName(value="test that undeploy closes the module class loader")
    void testUndeployClosesModuleClassLoader() throws IOException {
        URLClassLoader classLoaderMock = (URLClassLoader)Mockito.mock(URLClassLoader.class);
        PendingDeployment deployment = new DeployableModule("module", classLoaderMock, List.of()).deploy(NeonBeeMockHelper.registerNeonBeeMock(NeonBeeMockHelper.defaultVertxMock()));
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((Boolean)deployment.undeploy().succeeded()).isTrue();
        ((URLClassLoader)Mockito.verify((Object)classLoaderMock)).close();
    }

    @Test
    @DisplayName(value="test fromJar")
    void testFromJar() throws IOException {
        NeonBeeModuleJar moduleJar = NeonBeeModuleJar.create("testmodule").withVerticles().withModels().build();
        Path moduleJarPath = moduleJar.writeToTempPath();
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        Future deployableFuture = DeployableModule.fromJar((Vertx)vertxMock, (Path)moduleJarPath);
        Truth.assertThat((Throwable)deployableFuture.cause()).isNull();
        Truth.assertThat((Boolean)deployableFuture.succeeded()).isTrue();
        DeployableModule deployable = (DeployableModule)deployableFuture.result();
        Truth.assertThat((String)deployable.moduleName).isEqualTo((Object)"testmodule");
        Truth.assertThat((Object)deployable.moduleClassLoader).isNotNull();
        Truth.assertThat((Object[])deployable.moduleClassLoader.getURLs()).asList().containsExactly(new Object[]{moduleJarPath.toUri().toURL()});
        Truth.assertThat((Boolean)deployable.keepPartialDeployment).isFalse();
        List deployables = deployable.getDeployables();
        List deployableModels = deployables.stream().filter(DeployableModels.class::isInstance).map(DeployableModels.class::cast).collect(Collectors.toList());
        Truth.assertThat(deployableModels).hasSize(1);
        Truth.assertThat((Map)((DeployableModels)deployableModels.get((int)0)).modelDefinition.getCSNModelDefinitions()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"is not equal to")).containsExactlyEntriesIn(NeonBeeModuleJar.DUMMY_MODELS);
        Truth.assertThat((Map)((DeployableModels)deployableModels.get((int)0)).modelDefinition.getAssociatedModelDefinitions()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"is not equal to")).containsExactlyEntriesIn(NeonBeeModuleJar.DUMMY_EXTENSION_MODELS);
        Truth8.assertThat(deployables.stream().filter(DeployableVerticle.class::isInstance).map(DeployableVerticle.class::cast).map(deployableVerticle -> deployableVerticle.verticleClass).map(Class::getName)).containsExactlyElementsIn(NeonBeeModuleJar.DUMMY_VERTICLES);
    }

    @Test
    @DisplayName(value="test fromJar without verticles")
    void testFromJarWithoutVerticles() throws IOException {
        NeonBeeModuleJar moduleJar = NeonBeeModuleJar.create("testmodule").withModels().build();
        Path moduleJarPath = moduleJar.writeToTempPath();
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        Future deployableFuture = DeployableModule.fromJar((Vertx)vertxMock, (Path)moduleJarPath);
        Truth.assertThat((Throwable)deployableFuture.cause()).isNull();
        Truth.assertThat((Boolean)deployableFuture.succeeded()).isTrue();
        DeployableModule deployable = (DeployableModule)deployableFuture.result();
        Truth.assertThat((String)deployable.moduleName).isEqualTo((Object)"testmodule");
        Truth.assertThat((Object)deployable.moduleClassLoader).isNull();
        Truth.assertThat((Boolean)deployable.keepPartialDeployment).isFalse();
        List deployables = deployable.getDeployables();
        List deployableModels = deployables.stream().filter(DeployableModels.class::isInstance).map(DeployableModels.class::cast).collect(Collectors.toList());
        Truth.assertThat(deployableModels).hasSize(1);
        Truth.assertThat((Map)((DeployableModels)deployableModels.get((int)0)).modelDefinition.getCSNModelDefinitions()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"is not equal to")).containsExactlyEntriesIn(NeonBeeModuleJar.DUMMY_MODELS);
        Truth.assertThat((Map)((DeployableModels)deployableModels.get((int)0)).modelDefinition.getAssociatedModelDefinitions()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"is not equal to")).containsExactlyEntriesIn(NeonBeeModuleJar.DUMMY_EXTENSION_MODELS);
        Truth8.assertThat(deployables.stream().filter(DeployableVerticle.class::isInstance)).isEmpty();
    }

    @Test
    @DisplayName(value="test fromJar exceptions")
    void testFromJarExceptions() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        BasicJar noModuleAttribute = new BasicJar(Map.of(), Map.of());
        Throwable noModuleAttributeException = DeployableModule.fromJar((Vertx)vertxMock, (Path)noModuleAttribute.writeToTempPath()).cause();
        Truth.assertThat((Throwable)noModuleAttributeException).isInstanceOf(NoStackTraceThrowable.class);
        Truth.assertThat((Throwable)noModuleAttributeException).hasMessageThat().isEqualTo((Object)"No NeonBee-Module attribute found");
        BasicJar brokenJar = new BasicJar(NeonBeeModuleJar.createManifest("testmodule", List.of("Hodor")), Map.of());
        Throwable brokenJarException = DeployableModule.fromJar((Vertx)vertxMock, (Path)brokenJar.writeToTempPath()).cause();
        Truth.assertThat((Throwable)brokenJarException).isInstanceOf(ClassNotFoundException.class);
        Truth.assertThat((Throwable)brokenJarException).hasMessageThat().isEqualTo((Object)"Hodor");
        Mockito.when((Object)vertxMock.fileSystem().exists((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture((Object)false));
        Path nonExistingPath = FileSystemHelper.createTempDirectory().resolve("pathdoesnotexist");
        Throwable nonExistingPathException = DeployableModule.fromJar((Vertx)vertxMock, (Path)nonExistingPath).cause();
        Truth.assertThat((Throwable)nonExistingPathException).isInstanceOf(NoSuchFileException.class);
        Truth.assertThat((Throwable)nonExistingPathException).hasMessageThat().isEqualTo((Object)("JAR path does not exist: " + nonExistingPath.toString()));
    }
}

