/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.truth.Truth;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.DeployableTest;
import io.neonbee.internal.deploy.PendingDeployment;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.FutureInternal;
import io.vertx.core.impl.future.Listener;
import java.util.function.Function;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PendingDeploymentTest {
    PendingDeploymentTest() {
    }

    @Test
    void undeployTest() {
        TestPendingDeployment unresolved = new TestPendingDeployment((Future<String>)Promise.promise().future());
        Truth.assertThat((Throwable)unresolved.undeploy().cause()).isInstanceOf(IllegalStateException.class);
        TestPendingDeployment failed = new TestPendingDeployment((Future<String>)Future.failedFuture((String)""));
        Truth.assertThat((Boolean)failed.undeploy().succeeded()).isTrue();
        TestPendingDeployment succeeded = new TestPendingDeployment((Future<String>)Future.succeededFuture((Object)"deploymentId"));
        Truth.assertThat((Boolean)succeeded.undeploy().succeeded()).isTrue();
        Truth.assertThat((String)succeeded.undeployDeploymentId).isEqualTo((Object)"deploymentId");
    }

    @Test
    void getDeploymentIdTest() {
        String deploymentId = "Hodor";
        TestPendingDeployment deployment = new TestPendingDeployment((Future<String>)Future.succeededFuture((Object)deploymentId));
        Truth.assertThat((String)deployment.getDeploymentId()).isEqualTo((Object)deploymentId);
    }

    @Test
    void setHandlerTest() {
        Promise deployPromise = Promise.promise();
        TestPendingDeployment deployment = new TestPendingDeployment((Future<String>)deployPromise.future());
        Truth.assertThat((Boolean)deployment.isComplete()).isFalse();
        deployPromise.complete((Object)"test");
        Truth.assertThat((Boolean)deployment.isComplete()).isTrue();
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((String)deployment.result().getDeploymentId()).isEqualTo((Object)"test");
    }

    @Test
    void testFutureInterface() {
        FutureInternal futureMock = (FutureInternal)Mockito.mock(FutureInternal.class);
        ((FutureInternal)Mockito.doReturn((Object)futureMock).when((Object)futureMock)).map((Function)ArgumentMatchers.any());
        ((FutureInternal)Mockito.doReturn((Object)futureMock).when((Object)futureMock)).map((Object)((Deployable)ArgumentMatchers.any()));
        ((FutureInternal)Mockito.doReturn((Object)futureMock).when((Object)futureMock)).onSuccess((Handler)ArgumentMatchers.any());
        ((FutureInternal)Mockito.doReturn((Object)futureMock).when((Object)futureMock)).onFailure((Handler)ArgumentMatchers.any());
        TestPendingDeployment deployment = new TestPendingDeployment((Future<String>)futureMock);
        ((FutureInternal)Mockito.verify((Object)futureMock)).map((Function)ArgumentMatchers.any());
        ((FutureInternal)Mockito.verify((Object)futureMock)).onSuccess((Handler)ArgumentMatchers.any());
        ((FutureInternal)Mockito.verify((Object)futureMock)).onFailure((Handler)ArgumentMatchers.any());
        deployment.isComplete();
        ((FutureInternal)Mockito.verify((Object)futureMock)).isComplete();
        deployment.onComplete(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).onComplete((Handler)ArgumentMatchers.any());
        deployment.result();
        ((FutureInternal)Mockito.verify((Object)futureMock)).succeeded();
        Mockito.clearInvocations((Object[])new FutureInternal[]{futureMock});
        deployment.cause();
        ((FutureInternal)Mockito.verify((Object)futureMock)).cause();
        deployment.succeeded();
        ((FutureInternal)Mockito.verify((Object)futureMock)).succeeded();
        deployment.failed();
        ((FutureInternal)Mockito.verify((Object)futureMock)).failed();
        deployment.compose(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).compose((Function)ArgumentMatchers.any(), (Function)ArgumentMatchers.any());
        deployment.transform(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).transform((Function)ArgumentMatchers.any());
        deployment.eventually(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).eventually((Function)ArgumentMatchers.any());
        Mockito.clearInvocations((Object[])new FutureInternal[]{futureMock});
        deployment.map(null);
        ((FutureInternal)Mockito.verify((Object)futureMock, (VerificationMode)Mockito.atLeastOnce())).map(ArgumentMatchers.any(Object.class));
        Mockito.clearInvocations((Object[])new FutureInternal[]{futureMock});
        deployment.map(null);
        ((FutureInternal)Mockito.verify((Object)futureMock, (VerificationMode)Mockito.atLeastOnce())).map(ArgumentMatchers.any(Object.class));
        deployment.otherwise(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).otherwise((Function)ArgumentMatchers.any());
        deployment.otherwise(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).otherwise((Object)((String)ArgumentMatchers.any()));
        deployment.context();
        ((FutureInternal)Mockito.verify((Object)futureMock)).context();
        deployment.addListener(null);
        ((FutureInternal)Mockito.verify((Object)futureMock)).addListener((Listener)ArgumentMatchers.any());
    }

    private static class TestPendingDeployment
    extends PendingDeployment {
        public String undeployDeploymentId;

        protected TestPendingDeployment(Future<String> deployFuture) {
            super(null, (Deployable)new DeployableTest.DeployableThing("foo"), deployFuture);
        }

        public Future<Void> undeploy(String deploymentId) {
            this.undeployDeploymentId = deploymentId;
            return Future.succeededFuture();
        }
    }
}

