/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.config.ServerConfig;
import io.neonbee.internal.handler.DefaultErrorHandler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystemException;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;

@ExtendWith(value={VertxExtension.class})
class DefaultErrorHandlerTest {
    DefaultErrorHandlerTest() {
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testGetErrorHandlerDefault(Vertx vertx, VertxTestContext testContext) throws Exception {
        NeonBee neonBee = (NeonBee)Mockito.mock(NeonBee.class);
        ServerConfig config = (ServerConfig)Mockito.mock(ServerConfig.class);
        Mockito.when((Object)config.getErrorHandlerTemplate()).thenReturn((Object)"Hodor");
        Mockito.when((Object)neonBee.getServerConfig()).thenReturn((Object)config);
        Mockito.when((Object)neonBee.getVertx()).thenReturn((Object)vertx);
        new DefaultErrorHandler().initialize(neonBee).onComplete(testContext.failing(t -> testContext.verify(() -> {
            Truth.assertThat((Throwable)t).isInstanceOf(FileSystemException.class);
            Truth.assertThat((Throwable)t).hasMessageThat().contains((CharSequence)"Hodor");
            testContext.completeNow();
        })));
    }
}

