/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.json;

import com.google.common.truth.Truth;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ImmutableJsonObjectTest {
    ImmutableJsonObjectTest() {
    }

    @Test
    void testImmutableClass() {
        Truth.assertThat(new ImmutableJsonObject().getMap().getClass()).isEqualTo(Collections.unmodifiableMap(Collections.emptyMap()).getClass());
    }

    @Test
    void testEmpty() {
        Truth.assertThat((Iterable)ImmutableJsonObject.EMPTY).isEmpty();
        Truth.assertThat((Map)ImmutableJsonObject.EMPTY.getMap()).isEmpty();
        Truth.assertThat((Iterable)new ImmutableJsonObject()).isEqualTo((Object)ImmutableJsonObject.EMPTY);
    }

    @Test
    void testImmutable() {
        ImmutableJsonObject jsonObject = new ImmutableJsonObject();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)1L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)Float.valueOf(1.0f)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)1.0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)"String"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)new JsonObject()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)new JsonArray()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.put("keyX", (Object)new byte[]{0, 1}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.putNull("keyX"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.getMap().put("keyX", true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.mergeIn(new JsonObject().put("keyX", (Object)true)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.remove("keyX"));
    }

    @Test
    void testImmutableConstruction() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonObject().put("keyX", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonObject("{}").put("keyX", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonObject(Map.of("keyX", true)).put("keyY", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonObject(Buffer.buffer((String)"{}")).put("keyX", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonObject(new JsonObject()).put("keyX", (Object)true));
    }

    @Test
    void testGetPrimitives() {
        ImmutableJsonObject jsonObject = new ImmutableJsonObject(new JsonObject().put("key1", (Object)1).put("key2", (Object)true).put("key3", (Object)"String").putNull("key4"));
        Truth.assertThat((Integer)jsonObject.getInteger("key1")).isEqualTo((Object)1);
        Truth.assertThat((Boolean)jsonObject.getBoolean("key2")).isEqualTo((Object)true);
        Truth.assertThat((String)jsonObject.getString("key3")).isEqualTo((Object)"String");
        Truth.assertThat((Object)jsonObject.getValue("key4")).isNull();
        Truth.assertThat((Boolean)jsonObject.containsKey("key1")).isEqualTo((Object)true);
        Truth.assertThat((Boolean)jsonObject.containsKey("keyX")).isEqualTo((Object)false);
        Truth.assertThat((String)jsonObject.encode()).isEqualTo((Object)"{\"key1\":1,\"key2\":true,\"key3\":\"String\",\"key4\":null}");
        Truth.assertThat((Boolean)jsonObject.isEmpty()).isEqualTo((Object)false);
        Truth.assertThat((Integer)jsonObject.size()).isEqualTo((Object)4);
    }

    @Test
    void testGetComplexValues() {
        ImmutableJsonObject jsonObject = new ImmutableJsonObject(new JsonObject().put("object", (Object)new JsonObject().put("key1", (Object)1).put("key2", (Object)true).put("key3", (Object)"String").putNull("key4")).put("array", (Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3)));
        Truth.assertThat((Map)jsonObject.getJsonObject("object").getMap()).containsExactly((Object)"key1", (Object)1, new Object[]{"key2", true, "key3", "String", "key4", null});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.getJsonObject("object").put("keyX", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((JsonObject)jsonObject.getValue("object")).put("keyX", (Object)true));
        Truth.assertThat((Iterable)jsonObject.getJsonArray("array").getList()).containsExactly(new Object[]{1, 2, 3});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonObject.getJsonArray("array").add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((JsonArray)jsonObject.getValue("array")).add((Object)true));
    }

    @Test
    void testMutableCopyIsMutable() {
        Assertions.assertDoesNotThrow(() -> new ImmutableJsonObject().mutableCopy().put("keyX", (Object)true));
    }

    @Test
    void testCopyIsAlsoNotMutable() {
        ImmutableJsonObject object = new ImmutableJsonObject();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> object.copy().put("keyY", (Object)true));
        Truth.assertThat((Iterable)object.copy()).isSameInstanceAs((Object)object);
    }

    @Test
    void testStandardMethods() {
        JsonObject array = new JsonObject().put("foo", (Object)1).put("bar", (Object)"baz").put("bam", (Object)new JsonObject());
        ImmutableJsonObject immutableArray = new ImmutableJsonObject(array);
        Truth.assertThat((String)immutableArray.toString()).isEqualTo((Object)array.toString());
        Truth.assertThat((Integer)immutableArray.hashCode()).isEqualTo((Object)array.hashCode());
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)array);
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new ImmutableJsonObject(array));
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new ImmutableJsonObject((JsonObject)immutableArray));
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new JsonObject().put("foo", (Object)1).put("bar", (Object)"baz").put("bam", (Object)new JsonObject()));
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new ImmutableJsonObject(new JsonObject().put("foo", (Object)1).put("bar", (Object)"baz").put("bam", (Object)new JsonObject())));
        Truth.assertThat((Iterable)immutableArray).isNotEqualTo((Object)ImmutableJsonObject.EMPTY);
    }
}

