/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.logging;

import ch.qos.logback.classic.Level;
import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeExtension;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.internal.verticle.LoggerConfiguration;
import io.neonbee.internal.verticle.LoggerManagerVerticle;
import io.neonbee.test.helper.ConcurrentHelper;
import io.neonbee.test.helper.DeploymentHelper;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NeonBeeExtension.class})
class LoggerManagerVerticleClusterTest {
    private final DataContext dataContext = new DataContextImpl();

    LoggerManagerVerticleClusterTest() {
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    void testSetLoggerLevelInCluster(@NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee node1, @NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee node2, VertxTestContext testContext) {
        this.expectLogLevels(node1, "DEBUG", node2, "DEBUG", null, testContext);
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @Disabled
    void testSetLoggerLevelOnOneClusterNodeOnly(@NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee node1, @NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee node2, VertxTestContext testContext) {
        this.expectLogLevels(node1, "DEBUG", node2, "ERROR", query -> query.setParameter("local", new String[]{Boolean.toString(true)}), testContext);
    }

    private void expectLogLevels(NeonBee node1, String expectedLogLevel1, NeonBee node2, String expectedLogLevel2, Consumer<DataQuery> modifyQueryToNode1, VertxTestContext testContext) {
        List<LoggerConfiguration> configList = List.of(new LoggerConfiguration("io.neonbee.internal", Level.DEBUG));
        DataQuery updateQuery = new DataQuery().setAction(DataAction.UPDATE).setBody(new JsonArray(configList.stream().map(LoggerConfiguration::toJson).collect(Collectors.toList())).toBuffer());
        if (modifyQueryToNode1 != null) {
            modifyQueryToNode1.accept(updateQuery);
        }
        DataRequest updateReq = new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, updateQuery).setLocalOnly(true);
        DataRequest readReq = new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, new DataQuery().setParameter("loggers", new String[]{"io.neonbee.internal"})).setLocalOnly(true);
        CompositeFuture.all(DeploymentHelper.deployVerticle(node1.getVertx(), (Verticle)new LoggerManagerVerticle()), DeploymentHelper.deployVerticle(node2.getVertx(), (Verticle)new LoggerManagerVerticle())).compose(cf -> DataVerticle.requestData((Vertx)node1.getVertx(), (DataRequest)updateReq, (DataContext)this.dataContext)).compose(it -> ConcurrentHelper.waitFor(node1.getVertx(), 150L)).compose(up -> CompositeFuture.all((Future)DataVerticle.requestData((Vertx)node1.getVertx(), (DataRequest)readReq, (DataContext)this.dataContext), (Future)DataVerticle.requestData((Vertx)node2.getVertx(), (DataRequest)readReq, (DataContext)this.dataContext))).compose(cf -> {
            List node1Response = ((JsonArray)cf.resultAt(0)).stream().map(JsonObject.class::cast).map(LoggerConfiguration::fromJson).collect(Collectors.toList());
            List node2Response = ((JsonArray)cf.resultAt(1)).stream().map(JsonObject.class::cast).map(LoggerConfiguration::fromJson).collect(Collectors.toList());
            testContext.verify(() -> {
                Truth.assertThat((Iterable)node1Response).isNotEmpty();
                Optional<String> level = node1Response.stream().filter(config -> "io.neonbee.internal".equals(config.getName())).findFirst().map(LoggerConfiguration::getConfiguredLevel).map(theLevel -> theLevel.levelStr);
                Truth.assertThat((Boolean)level.isPresent()).isTrue();
                Truth.assertThat((String)level.get()).isEqualTo((Object)expectedLogLevel1);
                Truth.assertThat((Iterable)node2Response).isNotEmpty();
                level = node2Response.stream().filter(config -> "io.neonbee.internal".equals(config.getName())).findFirst().map(LoggerConfiguration::getConfiguredLevel).map(theLevel -> theLevel.levelStr);
                Truth.assertThat((Boolean)level.isPresent()).isTrue();
                Truth.assertThat((String)level.get()).isEqualTo((Object)expectedLogLevel2);
            });
            return Future.succeededFuture().mapEmpty();
        }).onComplete(testContext.succeedingThenComplete());
    }
}

