/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import io.neonbee.internal.BasicJar;
import io.neonbee.internal.ClassTemplate;
import io.neonbee.test.helper.ResourceHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AnnotatedClassTemplate
implements ClassTemplate {
    private static final String PLACEHOLDER_PACKAGE = "<package>";
    private static final String PLACEHOLDER_IMPORTS = "<imports>";
    private static final String PLACEHOLDER_CLASS_NAME = "<ClassName>";
    private static final String PLACEHOLDER_TYPE_ANNOTATION = "<TypeAnnotation>";
    private static final String PLACEHOLDER_FIELD_ANNOTATION = "<FieldAnnotation>";
    private static final String PLACEHOLDER_METHOD_ANNOTATION = "<MethodAnnotation>";
    private final String packageName;
    private final String simpleClassName;
    private final String template;
    private String typeAnnotation;
    private String fieldAnnotation;
    private String methodAnnotation;
    private List<String> imports = List.of();

    public AnnotatedClassTemplate(String simpleClassName) throws IOException {
        this(simpleClassName, null);
    }

    public AnnotatedClassTemplate(String simpleClassName, String packageName) throws IOException {
        this.packageName = packageName;
        this.simpleClassName = simpleClassName;
        this.template = ResourceHelper.TEST_RESOURCES.getRelated("AnnotatedClass.java.template").toString();
    }

    public AnnotatedClassTemplate setTypeAnnotation(String typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
        return this;
    }

    public AnnotatedClassTemplate setFieldAnnotation(String fieldAnnotation) {
        this.fieldAnnotation = fieldAnnotation;
        return this;
    }

    public AnnotatedClassTemplate setMethodAnnotation(String methodAnnotation) {
        this.methodAnnotation = methodAnnotation;
        return this;
    }

    public AnnotatedClassTemplate setImports(List<String> imports) {
        this.imports = imports;
        return this;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private String buildImportString() {
        StringBuilder sb = new StringBuilder();
        this.imports.forEach(i -> sb.append("import ").append((String)i).append(";\n"));
        return sb.toString();
    }

    @Override
    public String reifyTemplate() {
        Object packageNameReplacement = "";
        if (this.packageName != null) {
            packageNameReplacement = "package " + this.packageName + ";";
        }
        return this.template.replace(PLACEHOLDER_CLASS_NAME, this.simpleClassName).replace(PLACEHOLDER_IMPORTS, this.buildImportString()).replace(PLACEHOLDER_PACKAGE, (CharSequence)packageNameReplacement).replace(PLACEHOLDER_TYPE_ANNOTATION, Optional.ofNullable(this.typeAnnotation).orElse("")).replace(PLACEHOLDER_FIELD_ANNOTATION, Optional.ofNullable(this.fieldAnnotation).orElse("")).replace(PLACEHOLDER_METHOD_ANNOTATION, Optional.ofNullable(this.methodAnnotation).orElse(""));
    }

    @Override
    public String getSimpleName() {
        return this.simpleClassName;
    }

    public BasicJar asJar() throws IOException {
        return new BasicJar(Map.of(BasicJar.getJarEntryName(this.getClassName()), this.compileToByteCode()));
    }
}

