/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import com.google.common.collect.Streams;
import com.google.common.truth.Truth;
import io.neonbee.internal.BasicJar;
import io.neonbee.internal.helper.ThreadHelper;
import io.neonbee.internal.scanner.AnnotatedClassTemplate;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class ClassPathScannerTest {
    ClassPathScannerTest() {
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Should find passed attribute in all Manifest files")
    void scanManifestFilesTest(Vertx vertx, VertxTestContext testContext) throws IOException {
        String attribute1Name = "Attr1";
        String attribute2Name = "Attr2";
        List<String> manifest1Attribute1Values = List.of("M1A1V1", "M1A1V2");
        List<String> manifest1Attribute2Values = List.of("M1A2V1", "M1A2V2");
        List<String> manifest2Attribute1Values = List.of("M2A1V1", "M2A1V2");
        BasicJar jarWithManifest1 = new BasicJar(Map.of(attribute1Name, String.join((CharSequence)";", manifest1Attribute1Values), attribute2Name, String.join((CharSequence)";", manifest1Attribute2Values)), Map.of());
        BasicJar jarWithManifest2 = new BasicJar(Map.of(attribute1Name, String.join((CharSequence)";", manifest2Attribute1Values)), Map.of());
        URLClassLoader urlc = new URLClassLoader(new URL[]{jarWithManifest1.writeToTempPath().toUri().toURL(), jarWithManifest2.writeToTempPath().toUri().toURL()}, ClassLoader.getSystemClassLoader());
        List expected = Streams.concat((Stream[])new Stream[]{manifest1Attribute1Values.stream(), manifest2Attribute1Values.stream()}).collect(Collectors.toList());
        new ClassPathScanner((ClassLoader)urlc).scanManifestFiles(vertx, attribute1Name).onComplete(testContext.succeeding(list -> testContext.verify(() -> {
            Truth.assertThat((Iterable)list).containsExactlyElementsIn((Iterable)expected);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Should find files on the class path that match the passed prediction")
    void scanWithPredicateTest(Vertx vertx, VertxTestContext testContext) {
        List expected = Stream.of(ClassPathScanner.class, ClassPathScannerTest.class, ClassPathScanner.CloseableClassPathScanner.class).map(Class::getName).map(name -> name.replace(".", File.separator) + ".class").collect(Collectors.toList());
        new ClassPathScanner(ThreadHelper.getClassLoader()).scanWithPredicate(vertx, name -> name.startsWith(ClassPathScanner.class.getName().replace(".", File.separator))).onComplete(testContext.succeeding(paths -> testContext.verify(() -> {
            Truth.assertThat((Iterable)paths).isNotEmpty();
            if (!paths.stream().allMatch(path -> expected.stream().anyMatch(path::endsWith))) {
                testContext.failNow("Not all paths matched an expected value " + paths);
            } else {
                testContext.completeNow();
            }
        })));
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Should find files on the class path that are inside of a JAR file")
    void scanWithPredicateJarFile(Vertx vertx, VertxTestContext testContext) throws IOException, URISyntaxException {
        String ressourceToFind = "MyCoolResource";
        byte[] dummyContent = "lol".getBytes(StandardCharsets.UTF_8);
        BasicJar bj = new BasicJar(Map.of(ressourceToFind, dummyContent, "somethingElse", dummyContent));
        URLClassLoader urlc = new URLClassLoader(bj.writeToTempURL(), ClassLoader.getSystemClassLoader());
        String expectedUriString = urlc.getResource(ressourceToFind).toURI().toString().replace("file:/", "file:///");
        new ClassPathScanner((ClassLoader)urlc).scanJarFilesWithPredicate(vertx, name -> name.startsWith(ressourceToFind)).onComplete(testContext.succeeding(uris -> testContext.verify(() -> {
            Truth.assertThat((Iterable)uris).hasSize(1);
            Truth.assertThat((String)((URI)uris.get(0)).toString()).isEqualTo((Object)expectedUriString);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Should find classes which the class or any field or method within is annotated with a given annotation")
    void scanForAnnotation(Vertx vertx, VertxTestContext testContext) throws IOException {
        BasicJar jarWithTypeAnnotatedClass = new AnnotatedClassTemplate("Hodor", "type").setTypeAnnotation("@Deprecated").asJar();
        BasicJar jarWithFieldAnnotatedClass = new AnnotatedClassTemplate("Hodor", "field").setFieldAnnotation("@Deprecated").asJar();
        BasicJar jarWithMethodAnnotatedClass = new AnnotatedClassTemplate("Hodor", "method").setMethodAnnotation("@Deprecated").asJar();
        BasicJar jarWithMethodAnnotatedClass2 = new AnnotatedClassTemplate("Hodor2", "method").setMethodAnnotation("@Transient").setImports(List.of("java.beans.Transient")).asJar();
        URL[] urlc = (URL[])Stream.of(jarWithTypeAnnotatedClass.writeToTempURL(), jarWithFieldAnnotatedClass.writeToTempURL(), jarWithMethodAnnotatedClass.writeToTempURL(), jarWithMethodAnnotatedClass2.writeToTempURL()).flatMap(Stream::of).toArray(URL[]::new);
        ClassPathScanner cps = new ClassPathScanner((ClassLoader)new URLClassLoader(urlc, null));
        Checkpoint annotationsScanned = testContext.checkpoint(5);
        ClassPathScannerTest.futureContainsExactly(testContext, annotationsScanned, (Future<List<String>>)cps.scanForAnnotation(vertx, Deprecated.class, new ElementType[]{ElementType.TYPE}), "type.Hodor");
        ClassPathScannerTest.futureContainsExactly(testContext, annotationsScanned, (Future<List<String>>)cps.scanForAnnotation(vertx, Deprecated.class, new ElementType[]{ElementType.FIELD}), "field.Hodor");
        ClassPathScannerTest.futureContainsExactly(testContext, annotationsScanned, (Future<List<String>>)cps.scanForAnnotation(vertx, Deprecated.class, new ElementType[]{ElementType.METHOD}), "method.Hodor");
        ClassPathScannerTest.futureContainsExactly(testContext, annotationsScanned, (Future<List<String>>)cps.scanForAnnotation(vertx, Deprecated.class, new ElementType[]{ElementType.TYPE, ElementType.FIELD, ElementType.METHOD}), "type.Hodor", "field.Hodor", "method.Hodor");
        ClassPathScannerTest.futureContainsExactly(testContext, annotationsScanned, (Future<List<String>>)cps.scanForAnnotation(vertx, List.of(Transient.class, Deprecated.class), new ElementType[]{ElementType.METHOD}), "method.Hodor2", "method.Hodor");
    }

    private static void futureContainsExactly(VertxTestContext testContext, Checkpoint checkpoint, Future<List<String>> future, Object ... varargs) {
        future.onComplete(testContext.succeeding(list -> testContext.verify(() -> {
            Truth.assertThat(ClassPathScannerTest.filterInjectedFilesForIdeCoverageRuns(list)).containsExactly(varargs);
            checkpoint.flag();
        })));
    }

    private static List<String> filterInjectedFilesForIdeCoverageRuns(List<String> list) {
        return list.stream().filter(s -> !s.startsWith("org.jetbrains.coverage")).collect(Collectors.toList());
    }
}

