/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeOptions;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.internal.deploy.DeployableVerticle;
import io.neonbee.internal.verticle.HealthCheckVerticle;
import io.neonbee.test.base.DataVerticleTestBase;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HealthCheckVerticleTest
extends DataVerticleTestBase {
    HealthCheckVerticleTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        if ("testSharedMap".equals(((Method)testInfo.getTestMethod().get()).getName())) {
            options.setClustered(true);
        }
    }

    @Test
    @DisplayName(value="should respond with the check result of the registered check")
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testRetrieveData(VertxTestContext testContext) {
        DataRequest req = new DataRequest(HealthCheckVerticle.QUALIFIED_NAME, new DataQuery());
        Future response = this.requestData(req);
        this.assertData(response, (T resp) -> {
            Truth.assertThat((Integer)resp.size()).isEqualTo((Object)1);
            JsonObject firstCheck = resp.getJsonObject(0);
            Truth.assertThat((Boolean)firstCheck.containsKey("id")).isTrue();
            Truth.assertThat((Boolean)firstCheck.containsKey("status")).isTrue();
            Truth.assertThat((Boolean)firstCheck.containsKey("outcome")).isFalse();
        }, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @DisplayName(value="should register itself in shared map")
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testSharedMap(VertxTestContext testContext) {
        this.getNeonBee().getAsyncMap().get((Object)"healthCheckVerticles").onComplete(testContext.succeeding(qualifiedNamesOrNull -> testContext.verify(() -> {
            String expectedName = HealthCheckVerticle.QUALIFIED_NAME;
            Truth.assertThat((Iterable)((JsonArray)qualifiedNamesOrNull)).containsExactly(new Object[]{expectedName});
            testContext.completeNow();
        })));
    }

    @Test
    @DisplayName(value="should not register in shared map when non-clustered mode")
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testStartNonClustered(Vertx vertx, VertxTestContext testContext) {
        NeonBee neonBeeSpy = (NeonBee)Mockito.spy((Object)this.getNeonBee());
        DeployableVerticle.fromVerticle((Vertx)vertx, (Verticle)new HealthCheckVerticle(), (JsonObject)new JsonObject()).compose(deployable -> deployable.deploy(neonBeeSpy)).onComplete(testContext.succeeding(r -> testContext.verify(() -> ((NeonBee)Mockito.verify((Object)neonBeeSpy, (VerificationMode)Mockito.times((int)0))).getAsyncMap()))).onComplete(testContext.succeedingThenComplete());
    }
}

