/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import ch.qos.logback.classic.Level;
import com.google.common.truth.Truth;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.internal.verticle.LoggerConfiguration;
import io.neonbee.internal.verticle.LoggerManagerVerticle;
import io.neonbee.test.base.DataVerticleTestBase;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class LoggerManagerVerticleTest
extends DataVerticleTestBase {
    LoggerManagerVerticleTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        this.deployVerticle((Verticle)new LoggerManagerVerticle()).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testRetrieveData(VertxTestContext testContext) {
        DataRequest req = new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, new DataQuery());
        Future response = this.requestData(req);
        this.assertData(response, (T resp) -> Truth.assertThat((Iterable)resp).isNotEmpty(), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testRetrieveDataWithQuery(VertxTestContext testContext) {
        DataRequest req = new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, new DataQuery().setParameter("loggers", new String[]{"io.neonbee.internal"}));
        Future response = this.requestData(req);
        this.assertData(response, (T resp) -> {
            Truth.assertThat((Iterable)resp).hasSize(1);
            LoggerConfiguration config = LoggerConfiguration.fromJson((JsonObject)resp.getJsonObject(0));
            Truth.assertThat((String)config.getName()).isEqualTo((Object)"io.neonbee.internal");
            testContext.completeNow();
        }, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testRetrieveDataWithMultipleQueryValues(VertxTestContext testContext) {
        DataRequest req = new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, new DataQuery().setParameter("loggers", new String[]{"io.neonbee.internal,io.vertx.core.file"}));
        Future response = this.requestData(req);
        this.assertData(response, (T resp) -> Truth.assertThat((Iterable)resp).hasSize(2), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testUpdateData(VertxTestContext testContext) {
        List<LoggerConfiguration> configList = List.of(new LoggerConfiguration("io.neonbee.internal", Level.ERROR), new LoggerConfiguration("io.vertx.core.file", Level.ERROR));
        DataRequest updateReq = new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, new DataQuery().setAction(DataAction.UPDATE).setBody(new JsonArray(configList.stream().map(LoggerConfiguration::toJson).collect(Collectors.toList())).toBuffer()));
        this.requestData(updateReq).compose(updateResponse -> this.requestData(new DataRequest(LoggerManagerVerticle.QUALIFIED_NAME, new DataQuery()))).onComplete(testContext.succeeding(resp -> {
            Truth.assertThat((Iterable)resp).isNotEmpty();
            Optional<String> level = resp.stream().map(JsonObject.class::cast).map(LoggerConfiguration::fromJson).filter(config -> "io.neonbee.internal".equals(config.getName())).findFirst().map(LoggerConfiguration::getConfiguredLevel).map(theLevel -> theLevel.levelStr);
            Truth.assertThat((Boolean)level.isPresent()).isTrue();
            Truth.assertThat((String)level.get()).isEqualTo((Object)"ERROR");
            level = resp.stream().map(JsonObject.class::cast).map(LoggerConfiguration::fromJson).filter(config -> "io.vertx.core.file".equals(config.getName())).findFirst().map(LoggerConfiguration::getConfiguredLevel).map(theLevel -> theLevel.levelStr);
            Truth.assertThat((Boolean)level.isPresent()).isTrue();
            Truth.assertThat((String)level.get()).isEqualTo((Object)"ERROR");
            testContext.completeNow();
        }));
    }
}

