/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.internal.verticle.WatchVerticle;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.ConcurrentHelper;
import io.neonbee.test.helper.DeploymentHelper;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class WatchVerticleTest
extends NeonBeeTestBase {
    private Path watchDir;

    WatchVerticleTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.setDoNotWatchFiles(false);
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @BeforeEach
    void beforeEach() throws IOException {
        this.watchDir = io.neonbee.test.helper.FileSystemHelper.createTempDirectory();
    }

    @AfterEach
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    void afterEach(Vertx vertx, VertxTestContext testContext) throws IOException {
        FileSystemHelper.deleteRecursive((Vertx)vertx, (Path)this.watchDir).recover(throwable -> {
            if (throwable.getCause() instanceof DirectoryNotEmptyException) {
                return ConcurrentHelper.waitFor(vertx, 250L).compose(nothing -> FileSystemHelper.deleteRecursive((Vertx)vertx, (Path)this.watchDir));
            }
            return Future.failedFuture((Throwable)throwable);
        }).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Constructor should set / calculate interval correct")
    void testConstructor() {
        WatchVerticle watchVerticle = new WatchVerticle(this.watchDir);
        Truth.assertThat((Long)watchVerticle.watchPeriodMillis).isEqualTo((Object)500);
        watchVerticle = new WatchVerticle(this.watchDir, 2L, TimeUnit.SECONDS, false, false);
        Truth.assertThat((Long)watchVerticle.watchPeriodMillis).isEqualTo((Object)2000);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test to do not watch files")
    void testDontWatchFiles() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setDoNotWatchFiles(true));
        WatchVerticle watchVerticle = new WatchVerticle(this.watchDir);
        watchVerticle.init(vertxMock, vertxMock.getOrCreateContext());
        Promise promiseMock = (Promise)Mockito.mock(Promise.class);
        watchVerticle.start(promiseMock);
        ((Promise)Mockito.verify((Object)promiseMock)).complete();
        ((Vertx)Mockito.verify((Object)vertxMock)).undeploy(ArgumentMatchers.anyString());
    }

    @Test
    @DisplayName(value="isCopyLogic should behave correct")
    void isCopyLogicTest() {
        Truth.assertThat((Boolean)WatchVerticle.isCopyLogic(null)).isFalse();
        Truth.assertThat((Boolean)WatchVerticle.isCopyLogic((JsonObject)new JsonObject())).isFalse();
        JsonObject noCopyLogic = new JsonObject().put("watchLogic", (Object)"something else which is not copy");
        Truth.assertThat((Boolean)WatchVerticle.isCopyLogic((JsonObject)noCopyLogic)).isFalse();
        JsonObject copyLogic = new JsonObject().put("watchLogic", (Object)"copy");
        Truth.assertThat((Boolean)WatchVerticle.isCopyLogic((JsonObject)copyLogic)).isTrue();
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Upcoming check intervals should be ignored, if processing of a predecessor interval is still in progress")
    @DisabledOnOs(value={OS.MAC}, disabledReason="Issues with File Watching Service on macOS. We need a cross-platform Java recursive directory watcher, that works well with macOS")
    void testBlocking(Vertx vertx, VertxTestContext testCtx) throws InterruptedException {
        AtomicReference<Promise> waitFutureReference = new AtomicReference<Promise>(Promise.promise());
        WatchVerticle watchVerticleSpy = (WatchVerticle)Mockito.spy((Object)new WatchVerticle(this.watchDir, 1L, TimeUnit.MILLISECONDS, false, false));
        ((WatchVerticle)Mockito.doAnswer(invocation -> waitFutureReference.get()).when((Object)watchVerticleSpy)).checkForChanges();
        DeploymentHelper.deployVerticle(vertx, (Verticle)watchVerticleSpy).compose(deploymentId -> ConcurrentHelper.waitFor(vertx, 100L).compose(v -> {
            testCtx.verify(() -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.times((int)1))).checkForChanges());
            waitFutureReference.getAndSet(Promise.promise()).complete();
            return ConcurrentHelper.waitFor(vertx, 100L);
        }).onComplete(testCtx.succeeding(v -> {
            testCtx.verify(() -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.times((int)2))).checkForChanges());
            testCtx.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Upcoming check intervals should not be ignored, if processing of a predecessor interval is still in progress")
    @DisabledOnOs(value={OS.MAC}, disabledReason="Issues with File Watching Service on macOS. We need a cross-platform Java recursive directory watcher, that works well with macOS")
    void testParallelProcessing(Vertx vertx, VertxTestContext testCtx) throws InterruptedException {
        WatchVerticle watchVerticleSpy = (WatchVerticle)Mockito.spy((Object)new WatchVerticle(this.watchDir, 10L, TimeUnit.MILLISECONDS, true, false));
        ((WatchVerticle)Mockito.doAnswer(invocation -> Promise.promise()).when((Object)watchVerticleSpy)).checkForChanges();
        DeploymentHelper.deployVerticle(vertx, (Verticle)watchVerticleSpy).compose(deploymentId -> ConcurrentHelper.waitFor(vertx, 110L)).onComplete(testCtx.succeeding(v -> {
            testCtx.verify(() -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)10))).checkForChanges());
            testCtx.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="CycleTest: WatchVerticle should detect that a file was created, modified and deleted")
    @DisabledOnOs(value={OS.MAC}, disabledReason="Issues with File Watching Service on macOS. We need a cross-platform Java recursive directory watcher, that works well with macOS")
    void test(Vertx vertx, VertxTestContext testCtx) throws InterruptedException {
        WatchVerticle watchVerticleSpy = (WatchVerticle)Mockito.spy((Object)new WatchVerticle(this.watchDir, 10L, TimeUnit.MINUTES, false, false));
        Path watchedFile = this.watchDir.resolve("watchedFile");
        DeploymentHelper.deployVerticle(vertx, (Verticle)watchVerticleSpy).compose(s -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFile, (Buffer)Buffer.buffer())).compose(v -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedCreate((Path)ArgumentMatchers.eq((Object)watchedFile)))).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFile, (Buffer)Buffer.buffer((byte[])WatchVerticleTest.toByte("Lord Citrange"))).compose(innerVoid -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedModify((Path)ArgumentMatchers.eq((Object)watchedFile))))).compose(v -> FileSystemHelper.deleteRecursive((Vertx)vertx, (Path)watchedFile).compose(innerVoid -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedDelete((Path)ArgumentMatchers.eq((Object)watchedFile))))).onComplete(testCtx.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="WatchVerticle should detect files which already existed in the watchDir before it was started.")
    @DisabledOnOs(value={OS.MAC}, disabledReason="Issues with File Watching Service on macOS. We need a cross-platform Java recursive directory watcher, that works well with macOS")
    void testExisting(Vertx vertx, VertxTestContext testCtx) throws InterruptedException {
        WatchVerticle watchVerticleSpy = (WatchVerticle)Mockito.spy((Object)new WatchVerticle(this.watchDir, 10L, TimeUnit.MINUTES, false, true));
        Path watchedFile = this.watchDir.resolve("watchedFile");
        FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFile, (Buffer)Buffer.buffer()).compose(v -> DeploymentHelper.deployVerticle(vertx, (Verticle)watchVerticleSpy)).compose(s -> {
            testCtx.verify(() -> WatchVerticleTest.verifyCreateModifyFile(watchVerticleSpy, watchedFile));
            return Future.succeededFuture();
        }).onComplete(testCtx.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="CycleTest: WatchVerticle should detect recursively that a file was created, modified and deleted")
    @DisabledOnOs(value={OS.MAC}, disabledReason="Issues with File Watching Service on macOS. We need a cross-platform Java recursive directory watcher, that works well with macOS")
    void testRecursivly(Vertx vertx, VertxTestContext testCtx) throws InterruptedException {
        WatchVerticle watchVerticleSpy = (WatchVerticle)Mockito.spy((Object)new WatchVerticle(this.watchDir, 10L, TimeUnit.MINUTES, false, true));
        Path watchedSubDir = this.watchDir.resolve("subDir");
        Path watchedSubSubDir = watchedSubDir.resolve("subSubDir");
        Path watchedFileInSubDir = watchedSubDir.resolve("watchedFile");
        Path watchedFileInSubSubDir = watchedSubSubDir.resolve("watchedSubFile");
        DeploymentHelper.deployVerticle(vertx, (Verticle)watchVerticleSpy).compose(s -> FileSystemHelper.createDirs((Vertx)vertx, (Path)watchedSubDir).compose(v -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedCreate((Path)ArgumentMatchers.eq((Object)watchedSubDir)))).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFileInSubDir, (Buffer)Buffer.buffer())).compose(v -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedCreate((Path)ArgumentMatchers.eq((Object)watchedFileInSubDir)))).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFileInSubDir, (Buffer)Buffer.buffer((byte[])WatchVerticleTest.toByte("Lord Citrange")))).compose(v -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedModify((Path)ArgumentMatchers.eq((Object)watchedFileInSubDir)))).compose(v -> FileSystemHelper.deleteRecursive((Vertx)vertx, (Path)watchedFileInSubDir)).compose(v -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy, (VerificationMode)Mockito.atLeast((int)1))).observedDelete((Path)ArgumentMatchers.eq((Object)watchedFileInSubDir))))).compose(v -> FileSystemHelper.createDirs((Vertx)vertx, (Path)watchedSubSubDir).compose(innerVoid -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy)).observedCreate((Path)ArgumentMatchers.eq((Object)watchedSubSubDir)))).compose(innerVoid -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFileInSubSubDir, (Buffer)Buffer.buffer())).compose(innerVoid -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy)).observedCreate((Path)ArgumentMatchers.eq((Object)watchedFileInSubSubDir))))).compose(v -> FileSystemHelper.deleteRecursive((Vertx)vertx, (Path)watchedSubDir).compose(innerVoid -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy)).observedDelete((Path)ArgumentMatchers.eq((Object)watchedSubDir)))).compose(innerVoid -> {
            testCtx.verify(() -> Truth.assertThat((Map)watchVerticleSpy.watchKeys).doesNotContainKey((Object)watchedSubDir));
            return Future.succeededFuture();
        }).compose(innerVoid -> WatchVerticleTest.verifyFileEvent(vertx, testCtx, watchVerticleSpy, () -> ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy)).observedDelete((Path)ArgumentMatchers.eq((Object)watchedSubSubDir)))).compose(innerVoid -> {
            testCtx.verify(() -> Truth.assertThat((Map)watchVerticleSpy.watchKeys).doesNotContainKey((Object)watchedSubSubDir));
            return Future.succeededFuture();
        })).onComplete(testCtx.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="CycleTest: WatchVerticle should detect existiting files recursively that a file was created and modified")
    @DisabledOnOs(value={OS.MAC}, disabledReason="Issues with File Watching Service on macOS. We need a cross-platform Java recursive directory watcher, that works well with macOS")
    void testHandleExistingRecursivly(Vertx vertx, VertxTestContext testCtx) throws InterruptedException {
        WatchVerticle watchVerticleSpy = (WatchVerticle)Mockito.spy((Object)new WatchVerticle(this.watchDir, 10L, TimeUnit.MINUTES, false, true));
        Path watchedFile = this.watchDir.resolve("watchedFile");
        Path watchedSubDir = this.watchDir.resolve("watchedSubDir");
        Path watchedFileInSubDir = watchedSubDir.resolve("watchedFileInSubDir");
        Path watchedFileTwoInSubDir = watchedSubDir.resolve("watchedFileTwoInSubDir");
        Path watchedDirInSubDir = watchedSubDir.resolve("watchedDirInSubDir");
        Path watchedFileInSubSubDir = watchedDirInSubDir.resolve("watchedFile");
        Future createFileStructure = FileSystemHelper.createDirs((Vertx)vertx, (Path)watchedDirInSubDir).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFile, (Buffer)Buffer.buffer())).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFileInSubDir, (Buffer)Buffer.buffer())).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFileTwoInSubDir, (Buffer)Buffer.buffer())).compose(v -> FileSystemHelper.writeFile((Vertx)vertx, (Path)watchedFileInSubSubDir, (Buffer)Buffer.buffer()));
        createFileStructure.compose(v -> DeploymentHelper.deployVerticle(vertx, (Verticle)watchVerticleSpy)).onComplete(testCtx.succeeding(s -> {
            testCtx.verify(() -> {
                WatchVerticleTest.verifyCreateModifyFile(watchVerticleSpy, watchedFile);
                WatchVerticleTest.verifyCreateModifyFile(watchVerticleSpy, watchedFileInSubDir);
                WatchVerticleTest.verifyCreateModifyFile(watchVerticleSpy, watchedFileTwoInSubDir);
                WatchVerticleTest.verifyCreateModifyFile(watchVerticleSpy, watchedDirInSubDir);
                WatchVerticleTest.verifyCreateModifyFile(watchVerticleSpy, watchedFileInSubSubDir);
            });
            testCtx.completeNow();
        }));
    }

    private static Future<Void> verifyFileEvent(Vertx vertx, VertxTestContext testCtx, WatchVerticle watchVerticleSpy, VertxTestContext.ExecutionBlock checks) {
        return ConcurrentHelper.waitFor(vertx, 100L).compose(nothing -> watchVerticleSpy.checkForChanges()).onComplete(s -> testCtx.verify(checks));
    }

    private static void verifyCreateModifyFile(WatchVerticle watchVerticleSpy, Path watchedFile) {
        ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy)).observedCreate((Path)ArgumentMatchers.eq((Object)watchedFile));
        ((WatchVerticle)Mockito.verify((Object)watchVerticleSpy)).observedModify((Path)ArgumentMatchers.eq((Object)watchedFile));
    }

    private static byte[] toByte(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }
}

