/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.logging;

import com.google.common.truth.Truth;
import io.neonbee.data.DataContext;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingFacadeTest {
    private static final LoggingFacade MOCKED_LOGGING_FACADE = (LoggingFacade)Mockito.mock(LoggingFacade.class, (Answer)Mockito.CALLS_REAL_METHODS);

    LoggingFacadeTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new LoggingFacade[]{MOCKED_LOGGING_FACADE});
    }

    @Test
    void testFactoryMethods() {
        Logger logger = LoggerFactory.getLogger((String)"wololo");
        Truth.assertThat((String)LoggingFacade.masqueradeLogger((Logger)logger).getName()).isEqualTo((Object)logger.getName());
        String loggerName = "Hodor";
        Truth.assertThat((String)LoggingFacade.create((String)loggerName).getName()).isEqualTo((Object)loggerName);
        Truth.assertThat((String)LoggingFacade.create(String.class).getName()).isEqualTo((Object)String.class.getName());
        Truth.assertThat((String)LoggingFacade.create().getName()).isEqualTo((Object)LoggingFacadeTest.class.getName());
    }

    @Test
    void testCorrelateWith() {
        String correlId = "Hodor";
        RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContextMock.get((String)ArgumentMatchers.eq((Object)"correlationId"))).thenReturn((Object)correlId);
        LoggingFacade mockedLoggingFacade = (LoggingFacade)Mockito.mock(LoggingFacade.class);
        Mockito.when((Object)mockedLoggingFacade.correlateWith((DataContext)ArgumentMatchers.any(DataContext.class))).thenCallRealMethod();
        Mockito.when((Object)mockedLoggingFacade.correlateWith((RoutingContext)ArgumentMatchers.any(RoutingContext.class))).thenCallRealMethod();
        mockedLoggingFacade.correlateWith((DataContext)new DataContextImpl(correlId, null, null));
        mockedLoggingFacade.correlateWith(routingContextMock);
        ((LoggingFacade)Mockito.verify((Object)mockedLoggingFacade, (VerificationMode)Mockito.times((int)2))).correlateWith((String)ArgumentMatchers.eq((Object)correlId));
        Mockito.when((Object)mockedLoggingFacade.correlateWith((RoutingContext)ArgumentMatchers.isNull())).thenCallRealMethod();
        Assert.assertThrows(NullPointerException.class, () -> mockedLoggingFacade.correlateWith((RoutingContext)null));
    }
}

