/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.base;

import com.google.common.io.Resources;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeExtension;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.internal.deploy.DeployableVerticle;
import io.neonbee.internal.deploy.Deployment;
import io.neonbee.internal.handler.ChainAuthHandler;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.verticle.ServerVerticle;
import io.neonbee.test.helper.ConcurrentHelper;
import io.neonbee.test.helper.DeploymentHelper;
import io.neonbee.test.helper.DummyVerticleHelper;
import io.neonbee.test.helper.FileSystemHelper;
import io.neonbee.test.helper.OptionsHelper;
import io.neonbee.test.helper.SystemHelper;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.neonbee.test.listeners.StaleVertxChecker;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={VertxExtension.class})
public class NeonBeeTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(NeonBeeTestBase.class);
    private static final JsonObject NO_USER_PRINCIPAL = new JsonObject();
    private Path workingDirPath;
    private NeonBee neonBee;
    private boolean isDummyServerVerticleDeployed;

    @BeforeEach
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    public void setUp(Vertx vertx, VertxTestContext testContext, TestInfo testInfo) throws Exception {
        StaleVertxChecker.VERTX_TEST_MAP.put((Object)vertx, (Object)testInfo.getDisplayName());
        this.workingDirPath = FileSystemHelper.createTempDirectory();
        this.provideWorkingDirectoryBuilder(testInfo, testContext).build(this.workingDirPath);
        NeonBeeOptions.Mutable options = OptionsHelper.defaultOptions();
        this.adaptOptions(testInfo, options);
        options.setWorkingDirectory(this.workingDirPath);
        AtomicBoolean customUserPrincipal = new AtomicBoolean(false);
        if (this.provideUserPrincipal(testInfo) != NO_USER_PRINCIPAL) {
            if (!NeonBeeProfile.WEB.isActive((Collection)options.getActiveProfiles())) {
                testContext.failNow((Throwable)new IllegalStateException("A custom user principal can only be set, if the WEB profile is active!"));
                return;
            }
            options.addActiveProfile(NeonBeeProfile.NO_WEB);
            customUserPrincipal.set(true);
        }
        URL defaultLogbackConfig = Resources.getResource(NeonBeeTestBase.class, (String)"NeonBeeTestBase-Logback.xml");
        try (InputStream is = Resources.asByteSource((URL)defaultLogbackConfig).openStream();){
            Files.copy(is, options.getConfigDirectory().resolve("logback.xml"), new CopyOption[0]);
        }
        Future<NeonBee> future = NeonBeeMockHelper.createNeonBee(vertx, (NeonBeeOptions)options);
        CountDownLatch latch = new CountDownLatch(1);
        future.onComplete(asyncNeonBee -> {
            if (asyncNeonBee.failed()) {
                testContext.failNow(asyncNeonBee.cause());
                latch.countDown();
            } else {
                this.neonBee = (NeonBee)asyncNeonBee.result();
                if (customUserPrincipal.get()) {
                    DeploymentOptions serverVerticleOptions = WorkingDirectoryBuilder.readDeploymentOptions(ServerVerticle.class, this.workingDirPath);
                    try {
                        options.setServerPort(Integer.valueOf(SystemHelper.getFreePort()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ServerVerticle dummyServerVerticle = this.createDummyServerVerticle(testInfo);
                    serverVerticleOptions.getConfig().put("port", (Object)options.getServerPort());
                    serverVerticleOptions.getConfig().put("authenticationChain", (Object)new JsonArray());
                    WorkingDirectoryBuilder.writeDeploymentOptions(ServerVerticle.class, serverVerticleOptions, this.workingDirPath);
                    this.undeployVerticles(ServerVerticle.class).compose(nothing -> this.deployVerticle((Verticle)dummyServerVerticle, serverVerticleOptions)).onComplete(result -> {
                        if (result.succeeded()) {
                            this.isDummyServerVerticleDeployed = true;
                        }
                        testContext.succeedingThenComplete().handle((Object)result.mapEmpty());
                        latch.countDown();
                    });
                } else {
                    testContext.completeNow();
                    latch.countDown();
                }
            }
        });
        if (!latch.await(60L, NeonBeeExtension.DEFAULT_TIMEOUT_UNIT)) {
            throw new TimeoutException("Preparing NeonBee timed out");
        }
    }

    @AfterEach
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    void tearDown(Vertx vertx, VertxTestContext testContext) throws IOException {
        FileSystemHelper.deleteRecursive(vertx, this.workingDirPath).recover(throwable -> {
            if (throwable.getCause() instanceof DirectoryNotEmptyException) {
                return ConcurrentHelper.waitFor(vertx, 250L).compose(nothing -> FileSystemHelper.deleteRecursive(vertx, this.workingDirPath));
            }
            return Future.failedFuture((Throwable)throwable);
        }).onComplete(testContext.succeedingThenComplete());
    }

    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
    }

    protected JsonObject provideUserPrincipal(TestInfo testInfo) {
        return NO_USER_PRINCIPAL;
    }

    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        return WorkingDirectoryBuilder.standard();
    }

    public final NeonBee getNeonBee() {
        return this.neonBee;
    }

    public Future<Deployment> deployVerticle(Verticle verticle) {
        return DeployableVerticle.fromVerticle((Vertx)this.neonBee.getVertx(), (Verticle)verticle, null).compose(deployable -> deployable.deploy(this.neonBee)).onSuccess(result -> LOGGER.info("Successfully deployed verticle {}", (Object)verticle)).onFailure(throwable -> LOGGER.error("Failed to deploy verticle {}", (Object)verticle, throwable));
    }

    public Future<Deployment> deployVerticle(Verticle verticle, DeploymentOptions options) {
        return new DeployableVerticle(verticle, options).deploy(this.neonBee).onSuccess(result -> LOGGER.info("Successfully deployed verticle {}", (Object)verticle)).onFailure(throwable -> LOGGER.error("Failed to deploy verticle {}", (Object)verticle, throwable));
    }

    public Future<Deployment> deployVerticle(Class<? extends Verticle> verticleClass) {
        return DeployableVerticle.fromClass((Vertx)this.neonBee.getVertx(), verticleClass, null).compose(deployable -> deployable.deploy(this.neonBee)).onSuccess(result -> LOGGER.info("Successfully deployed verticle with class {}", (Object)verticleClass.getName())).onFailure(throwable -> LOGGER.error("Failed to deploy verticle with class {}", (Object)verticleClass.getName(), throwable));
    }

    public Future<Deployment> deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
        return new DeployableVerticle(verticleClass, options).deploy(this.neonBee).onSuccess(result -> LOGGER.info("Successfully deployed verticle with class {}", (Object)verticleClass.getName())).onFailure(throwable -> LOGGER.error("Failed to deploy verticle with class {}", (Object)verticleClass.getName(), throwable));
    }

    public Future<Void> undeployVerticle(String deploymentId) {
        return DeploymentHelper.undeployVerticle(this.neonBee.getVertx(), deploymentId).onSuccess(result -> LOGGER.info("Successfully undeployed verticle with deployment ID {}", (Object)deploymentId)).onFailure(throwable -> LOGGER.error("Failed to undeployed verticle with deployment ID {}", (Object)deploymentId, throwable));
    }

    public Future<Void> undeployVerticles(Class<? extends Verticle> verticleClass) {
        return DeploymentHelper.undeployAllVerticlesOfClass(this.neonBee.getVertx(), verticleClass).onSuccess(result -> LOGGER.info("Successfully undeployed verticle(s) with class {}", (Object)verticleClass.getName())).onFailure(throwable -> LOGGER.error("Failed to undeployed verticle(s) with class {}", (Object)verticleClass.getName(), throwable));
    }

    public static Future<ServerConfig> readServerConfig(Vertx vertx) {
        return NeonBeeTestBase.readServerConfig(Objects.requireNonNull(NeonBee.get((Vertx)vertx), "Cannot resolve the server port as the provided Vert.x instance is not associated to a NeonBee instance"));
    }

    public static Future<ServerConfig> readServerConfig(NeonBee neonBee) {
        return ConfigHelper.readConfig((Vertx)neonBee.getVertx(), (String)ServerVerticle.class.getName()).map(DeploymentOptions::new).map(DeploymentOptions::getConfig).map(ServerConfig::new).onSuccess(config -> NeonBeeTestBase.overridePort(neonBee, config));
    }

    private static ServerConfig readServerConfig(NeonBee neonBee, Path workingDirPath) {
        ServerConfig config = new ServerConfig(WorkingDirectoryBuilder.readDeploymentOptions(ServerVerticle.class, workingDirPath).getConfig());
        NeonBeeTestBase.overridePort(neonBee, config);
        return config;
    }

    private static void overridePort(NeonBee neonBee, ServerConfig config) {
        Optional.ofNullable(neonBee.getOptions()).map(NeonBeeOptions::getServerPort).ifPresent(port -> config.setPort(port.intValue()));
    }

    public HttpRequest<Buffer> createRequest(HttpMethod method, String path) {
        WebClientOptions opts = new WebClientOptions().setDefaultHost("localhost").setDefaultPort(NeonBeeTestBase.readServerConfig(this.neonBee, this.workingDirPath).getPort());
        HttpRequest request = WebClient.create((Vertx)this.neonBee.getVertx(), (WebClientOptions)opts).request(method, path);
        return this.isDummyServerVerticleDeployed ? request.bearerTokenAuthentication("dummy") : request;
    }

    public DummyVerticleHelper.DummyDataVerticleFactory createDummyDataVerticle(String fqn) {
        return DummyVerticleHelper.createDummyDataVerticle(fqn);
    }

    public DummyVerticleHelper.DummyEntityVerticleFactory createDummyEntityVerticle(FullQualifiedName fqn) {
        return DummyVerticleHelper.createDummyEntityVerticle(fqn);
    }

    private ServerVerticle createDummyServerVerticle(TestInfo testInfo) {
        final ChainAuthHandler dummyAuthHandler = ctx -> {
            ctx.setUser(User.create((JsonObject)this.provideUserPrincipal(testInfo)));
            Session session = ctx.session();
            if (session != null) {
                session.regenerateId();
            }
            ctx.next();
        };
        return new ServerVerticle(){

            protected Future<Void> mountEndpoints(Router router, List<EndpointConfig> endpointConfigs, Optional<ChainAuthHandler> defaultAuthHandler) {
                return super.mountEndpoints(router, endpointConfigs, Optional.of(dummyAuthHandler));
            }
        };
    }
}

