/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.base;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeOptions;
import io.neonbee.data.DataVerticle;
import io.neonbee.test.base.NeonBeeTestBase;
import io.vertx.core.Verticle;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class NeonBeeTestBaseTest
extends NeonBeeTestBase {
    private static final JsonObject PRINCIPAL = new JsonObject().put("Hodor", (Object)"Hodor");

    NeonBeeTestBaseTest() {
    }

    @Override
    protected JsonObject provideUserPrincipal(TestInfo testInfo) {
        return PRINCIPAL;
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        if ("testAdaptOptions".equals(testInfo.getTestMethod().map(Method::getName).orElse(null))) {
            options.setInstanceName("foo-bar-instance");
        }
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="test that the dummy user principal is available in the DataContext")
    void testProvideUserPrincipal(VertxTestContext testContext) {
        DataVerticle<Void> dummy = this.createDummyDataVerticle("test/Dummy").withDynamicResponse((query, context) -> {
            testContext.verify(() -> Truth.assertThat((Iterable)context.userPrincipal()).isEqualTo((Object)PRINCIPAL));
            return null;
        });
        this.deployVerticle((Verticle)dummy).compose(v -> this.createRequest(HttpMethod.GET, "/raw/test/Dummy").send()).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @DisplayName(value="test that the adapt options can be used to adapt NeonBee options")
    void testAdaptOptions() {
        Truth.assertThat((String)this.getNeonBee().getOptions().getInstanceName()).isEqualTo((Object)"foo-bar-instance");
    }

    @Test
    @DisplayName(value="test that the adapt options can be used to not adapt NeonBee options")
    void testNotAdaptOptions() {
        Truth.assertThat((String)this.getNeonBee().getOptions().getInstanceName()).isNotEqualTo((Object)"foo-bar-instance");
    }
}

