/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.base;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.neonbee.NeonBee;
import io.neonbee.endpoint.odatav4.ODataV4Endpoint;
import io.neonbee.test.base.NeonBeeTestBase;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class ODataRequest {
    private final FullQualifiedName entity;
    private HttpMethod method = HttpMethod.GET;
    private boolean metadata;
    private boolean count;
    private Map<String, String> keys = new HashMap<String, String>();
    private MultiMap query = MultiMap.caseInsensitiveMultiMap();
    private MultiMap headers = MultiMap.caseInsensitiveMultiMap();
    private Consumer<HttpRequest<Buffer>> interceptor;
    private String property;
    private String systemQueryExpand;
    private Buffer body;

    public ODataRequest(FullQualifiedName entity) {
        this.entity = entity;
    }

    public ODataRequest setMethod(HttpMethod method) {
        this.method = Optional.ofNullable(method).orElse(HttpMethod.GET);
        return this;
    }

    public ODataRequest setBody(Buffer body) {
        this.body = body;
        return this;
    }

    public Future<HttpResponse<Buffer>> send(NeonBee neonBee) {
        Vertx vertx = neonBee.getVertx();
        return NeonBeeTestBase.readServerConfig(neonBee).compose(config -> {
            int port = config.getPort();
            String basePath = config.getEndpointConfigs().stream().filter(eConfig -> ODataV4Endpoint.class.getSimpleName().equals(eConfig.getType())).findFirst().map(eConfig -> eConfig.getBasePath()).orElse("/odata/");
            WebClientOptions clientOpts = new WebClientOptions().setDefaultHost("localhost").setDefaultPort(port);
            HttpRequest httpRequest = WebClient.create((Vertx)vertx, (WebClientOptions)clientOpts).request(this.method, basePath + this.getUri());
            httpRequest.queryParams().addAll(this.query);
            httpRequest.putHeaders(this.headers);
            Optional.ofNullable(this.interceptor).ifPresent(i -> i.accept(httpRequest));
            httpRequest.queryParams();
            return Optional.ofNullable(this.body).map(arg_0 -> ((HttpRequest)httpRequest).sendBuffer(arg_0)).orElse(httpRequest.send());
        });
    }

    public ODataRequest setMetadata() {
        this.metadata = true;
        return this;
    }

    public ODataRequest setCount() {
        this.count = true;
        return this;
    }

    public ODataRequest setKey(String id) {
        this.setKey(Map.of("", id));
        return this;
    }

    public ODataRequest setKey(long id) {
        this.setKey(Map.of("", id));
        return this;
    }

    public ODataRequest setKey(LocalDate id) {
        this.setKey(Map.of("", id));
        return this;
    }

    public ODataRequest setKey(Map<String, Object> compositeKey) {
        Function<Object, String> convert = obj -> {
            if (obj instanceof String) {
                return "'" + obj + "'";
            }
            if (obj instanceof Long) {
                return obj.toString();
            }
            if (obj instanceof LocalDate) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                return ((LocalDate)obj).format(formatter);
            }
            throw new IllegalArgumentException("Expecting either type String or Long as key, but received " + obj.getClass().getCanonicalName());
        };
        this.keys = compositeKey.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> (String)convert.apply(entry.getValue())));
        return this;
    }

    public ODataRequest setProperty(String propertyName) {
        this.property = propertyName;
        return this;
    }

    public ODataRequest addQueryParam(String key, String value) {
        this.query.add(key, value);
        return this;
    }

    public ODataRequest setQuery(Map<String, String> query) {
        this.setQuery(Objects.isNull(query) ? null : MultiMap.caseInsensitiveMultiMap().addAll(query));
        return this;
    }

    public ODataRequest setQuery(MultiMap query) {
        this.query = Optional.ofNullable(query).orElse(MultiMap.caseInsensitiveMultiMap());
        return this;
    }

    public ODataRequest addHeader(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    public ODataRequest setHeaders(Map<String, String> headers) {
        this.setHeaders(Objects.isNull(headers) ? null : MultiMap.caseInsensitiveMultiMap().addAll(headers));
        return this;
    }

    public ODataRequest setHeaders(MultiMap headers) {
        this.headers = Optional.ofNullable(headers).orElse(MultiMap.caseInsensitiveMultiMap());
        return this;
    }

    public ODataRequest interceptRequest(Consumer<HttpRequest<Buffer>> interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public ODataRequest setExpandQuery(String expandValue) {
        this.systemQueryExpand = "expand=" + expandValue;
        return this;
    }

    protected String getUri() {
        String namespace;
        String string = namespace = Strings.isNullOrEmpty((String)this.entity.getNamespace()) ? "" : this.entity.getNamespace() + "/";
        if (this.metadata) {
            return namespace + "$metadata";
        }
        String entitySet = namespace + this.entity.getName();
        if (this.count) {
            return entitySet + "/$count";
        }
        return entitySet + this.getPredicate(this.keys) + (String)(Strings.isNullOrEmpty((String)this.property) ? "" : "/" + this.property) + (String)(Strings.isNullOrEmpty((String)this.systemQueryExpand) ? "" : "?$" + this.systemQueryExpand);
    }

    private String getPredicate(Map<String, String> keyMap) throws IllegalArgumentException {
        if (keyMap.isEmpty()) {
            return "";
        }
        Function<String, String> decorateParentheses = s -> "(" + s + ")";
        if (keyMap.size() == 1) {
            return decorateParentheses.apply(keyMap.values().iterator().next());
        }
        if (this.keys.containsKey("")) {
            throw new IllegalArgumentException("For multi-part keys the full key predicate is required.");
        }
        return decorateParentheses.apply(Joiner.on((char)',').withKeyValueSeparator('=').join(this.keys.entrySet()));
    }
}

