/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.NavPropsCategoriesEntityVerticle;
import io.neonbee.test.endpoint.odata.verticle.NavPropsProductsEntityVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ODataExpandEntityTest
extends ODataEndpointTestBase {
    ODataExpandEntityTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(NavPropsProductsEntityVerticle.getDeclaredEntityModel());
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        CompositeFuture.all(this.deployVerticle((Verticle)new NavPropsProductsEntityVerticle()), this.deployVerticle((Verticle)new NavPropsCategoriesEntityVerticle())).onComplete(testContext.succeedingThenComplete());
    }

    static Stream<Arguments> withProducts() {
        BiFunction<JsonObject, JsonObject, Arguments> buildArgument = (product, category) -> Arguments.of((Object[])new Object[]{product, NavPropsProductsEntityVerticle.addCategoryToProduct(product, category)});
        return Stream.of(buildArgument.apply(NavPropsProductsEntityVerticle.STEAK_PRODUCT, NavPropsCategoriesEntityVerticle.FOOD_CATEGORY), buildArgument.apply(NavPropsProductsEntityVerticle.CHEESE_PRODUCT, NavPropsCategoriesEntityVerticle.FOOD_CATEGORY), buildArgument.apply(NavPropsProductsEntityVerticle.S_1000_RR_PRODUCT, NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY), buildArgument.apply(NavPropsProductsEntityVerticle.STREET_GLIDE_SPECIAL_PRODUCT, NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY));
    }

    @ParameterizedTest(name="{index}: Expand {0} to {1}")
    @MethodSource(value={"withProducts"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Expand property 'category' in Product")
    void testExpandCategoryInProducts(JsonObject product, JsonObject expected, VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsProductsEntityVerticle.PRODUCTS_ENTITY_SET_FQN).setExpandQuery("category").setKey(product.getInteger("ID").intValue());
        this.assertODataEntity(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Do not expand property 'category' in a specific Product")
    void testDoNotExpandCategoryInProducts(VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsProductsEntityVerticle.PRODUCTS_ENTITY_SET_FQN).setKey(NavPropsProductsEntityVerticle.STEAK_PRODUCT.getInteger("ID").intValue());
        this.assertODataEntity(this.requestOData(oDataRequest), NavPropsProductsEntityVerticle.STEAK_PRODUCT, testContext).onComplete(testContext.succeedingThenComplete());
    }

    static Stream<Arguments> withCategories() {
        BiFunction<JsonObject, List, Arguments> buildArgument = (category, products) -> Arguments.of((Object[])new Object[]{category, NavPropsCategoriesEntityVerticle.addProductsToCategory(category, products)});
        return Stream.of(buildArgument.apply(NavPropsCategoriesEntityVerticle.FOOD_CATEGORY, List.of(NavPropsProductsEntityVerticle.STEAK_PRODUCT, NavPropsProductsEntityVerticle.CHEESE_PRODUCT)), buildArgument.apply(NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY, List.of(NavPropsProductsEntityVerticle.S_1000_RR_PRODUCT, NavPropsProductsEntityVerticle.STREET_GLIDE_SPECIAL_PRODUCT)));
    }

    @ParameterizedTest(name="{index}: Expand {0} to {1}")
    @MethodSource(value={"withCategories"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Expand property 'products' in Category")
    void testExpandProductsInCategory(JsonObject category, JsonObject expected, VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsCategoriesEntityVerticle.CATEGORIES_ENTITY_SET_FQN).setExpandQuery("products").setKey(category.getInteger("ID").intValue());
        this.assertODataEntity(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Do not expand property 'products' in a specific Category")
    void testDoNotExpandProductsInCategory(VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsCategoriesEntityVerticle.CATEGORIES_ENTITY_SET_FQN).setKey(NavPropsCategoriesEntityVerticle.FOOD_CATEGORY.getInteger("ID").intValue());
        this.assertODataEntity(this.requestOData(oDataRequest), NavPropsCategoriesEntityVerticle.FOOD_CATEGORY, testContext).onComplete(testContext.succeedingThenComplete());
    }
}

