/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.NavPropsCategoriesEntityVerticle;
import io.neonbee.test.endpoint.odata.verticle.NavPropsProductsEntityVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ODataNavigationPropertiesTest
extends ODataEndpointTestBase {
    ODataNavigationPropertiesTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(NavPropsProductsEntityVerticle.getDeclaredEntityModel());
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        CompositeFuture.all(this.deployVerticle((Verticle)new NavPropsProductsEntityVerticle()), this.deployVerticle((Verticle)new NavPropsCategoriesEntityVerticle())).onComplete(testContext.succeedingThenComplete());
    }

    static Stream<Arguments> withProducts() {
        return Stream.of(Arguments.of((Object[])new Object[]{NavPropsProductsEntityVerticle.STEAK_PRODUCT, NavPropsCategoriesEntityVerticle.FOOD_CATEGORY}), Arguments.of((Object[])new Object[]{NavPropsProductsEntityVerticle.CHEESE_PRODUCT, NavPropsCategoriesEntityVerticle.FOOD_CATEGORY}), Arguments.of((Object[])new Object[]{NavPropsProductsEntityVerticle.S_1000_RR_PRODUCT, NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY}), Arguments.of((Object[])new Object[]{NavPropsProductsEntityVerticle.STREET_GLIDE_SPECIAL_PRODUCT, NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY}));
    }

    @ParameterizedTest(name="{index}: For Product: {0}")
    @MethodSource(value={"withProducts"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Navigate to property 'category' in Product")
    void testNavigateToCategoryInProduct(JsonObject product, JsonObject expected, VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsProductsEntityVerticle.PRODUCTS_ENTITY_SET_FQN).setKey(product.getInteger("ID").intValue()).setProperty("category");
        this.assertODataEntity(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    static Stream<Arguments> withCategories() {
        Function<List, List> removeCategoryID = products -> products.stream().map(JsonObject::copy).peek(p -> p.remove("category_ID")).collect(Collectors.toList());
        return Stream.of(Arguments.of((Object[])new Object[]{NavPropsCategoriesEntityVerticle.FOOD_CATEGORY, removeCategoryID.apply(List.of(NavPropsProductsEntityVerticle.STEAK_PRODUCT, NavPropsProductsEntityVerticle.CHEESE_PRODUCT))}), Arguments.of((Object[])new Object[]{NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY, removeCategoryID.apply(List.of(NavPropsProductsEntityVerticle.S_1000_RR_PRODUCT, NavPropsProductsEntityVerticle.STREET_GLIDE_SPECIAL_PRODUCT))}));
    }

    @ParameterizedTest(name="{index}: For Category: {0}")
    @MethodSource(value={"withCategories"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Navigate to property 'products' in Category")
    void testNavigateToProductsInCategory(JsonObject category, List<JsonObject> expected, VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsCategoriesEntityVerticle.CATEGORIES_ENTITY_SET_FQN).setProperty("products").setKey(category.getInteger("ID").intValue());
        this.assertODataEntitySetContains(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }
}

