/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import com.google.common.truth.Truth;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.endpoint.odatav4.ODataV4Endpoint;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.internal.verticle.ServerVerticle;
import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.TestService1EntityVerticle;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class ODataReadEntitiesTest
extends ODataEndpointTestBase {
    private static final List<JsonObject> ALL_ENTITIES = List.of(TestService1EntityVerticle.EXPECTED_ENTITY_DATA_1, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_3, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_6);

    ODataReadEntitiesTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(TestService1EntityVerticle.getDeclaredEntityModel());
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        return super.provideWorkingDirectoryBuilder(testInfo, testContext).setCustomTask(root -> {
            String testMethodName = testInfo.getTestMethod().map(Method::getName).orElse("");
            ODataV4Endpoint.UriConversion uriConversion = ODataV4Endpoint.UriConversion.STRICT;
            if (testMethodName.contains("LooseUriConversion")) {
                uriConversion = ODataV4Endpoint.UriConversion.LOOSE;
            } else if (testMethodName.contains("CDSUriConversion")) {
                uriConversion = ODataV4Endpoint.UriConversion.CDS;
            }
            DeploymentOptions opts = WorkingDirectoryBuilder.readDeploymentOptions(ServerVerticle.class, root);
            EndpointConfig epc = new EndpointConfig().setType(ODataV4Endpoint.class.getName()).setAdditionalConfig(new JsonObject().put("uriConversion", (Object)uriConversion.toString()));
            ServerConfig sc = new ServerConfig(opts.getConfig()).setEndpointConfigs(List.of(epc));
            opts.setConfig(sc.toJson());
            WorkingDirectoryBuilder.writeDeploymentOptions(ServerVerticle.class, opts, root);
        });
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        this.deployVerticle((Verticle)new TestService1EntityVerticle()).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 404 if an non existing entity set is requested")
    void nonExistingEntityTest(VertxTestContext testContext) {
        FullQualifiedName notExistingEntities = new FullQualifiedName(TestService1EntityVerticle.TEST_ENTITY_SET_FQN.getNamespace(), "NotExistingEntities");
        new ODataRequest(notExistingEntities).send(this.getNeonBee()).onComplete(testContext.succeeding(response -> testContext.verify(() -> {
            JsonObject jsonResponse = response.bodyAsJsonObject().getJsonObject("error");
            Truth.assertThat((String)jsonResponse.getString("code")).isNull();
            Truth.assertThat((String)jsonResponse.getString("message")).isEqualTo((Object)"Cannot find EntitySet, Singleton, ActionImport or FunctionImport with name 'NotExistingEntities'.");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has test entities")
    void existingEntitiesTest(VertxTestContext testContext) {
        this.assertODataEntitySetContainsExactly(this.requestOData(new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN)), ALL_ENTITIES, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has test entities including correct inline count")
    void existingEntitiesWithInlineCountTest(VertxTestContext testContext) {
        Map<String, String> countQuery = Map.of("$count", "true");
        Future<HttpResponse<Buffer>> response = this.requestOData(new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).setQuery(countQuery));
        this.assertOData(response, (Buffer body) -> Truth.assertThat((Map)body.toJsonObject().getMap()).containsAtLeast((Object)"@odata.count", (Object)6, new Object[0]), testContext).compose(v -> this.assertODataEntitySetContainsExactly(response, ALL_ENTITIES, testContext)).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has test entities including correct inline count with applied filters")
    void existingEntitiesWithInlineCountAndFilterTest(VertxTestContext testContext) {
        List<JsonObject> expectedEntities = List.of(TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4);
        Map<String, String> query = Map.of("$filter", "KeyPropertyString in ('id.3', 'id-1')", "$count", "true");
        Future<HttpResponse<Buffer>> response = this.requestOData(new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).setQuery(query));
        this.assertOData(response, (Buffer body) -> Truth.assertThat((Map)body.toJsonObject().getMap()).containsAtLeast((Object)"@odata.count", (Object)2, new Object[0]), testContext).compose(v -> this.assertODataEntitySetContainsExactly(response, expectedEntities, testContext)).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 and the correct count of entities")
    void existingEntitiesCountTest(VertxTestContext testContext) {
        this.assertOData(this.requestOData(new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).setCount()), "6", testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test /$count returns 0 if no entities are found")
    void countNoEntitiesFoundTest(VertxTestContext testContext) {
        EntityVerticle dummy = this.createDummyEntityVerticle(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).withStaticResponse(List.of());
        this.undeployVerticles(TestService1EntityVerticle.class).compose(v -> this.deployVerticle((Verticle)dummy)).compose(v -> this.assertOData(this.requestOData(new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).setCount()), "0", testContext)).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=3, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 and the correct count of entities with filter query")
    void existingEntitiesCountWithFilterTest(VertxTestContext testContext) {
        Map<String, String> filterQuery = Map.of("$filter", "KeyPropertyString in ('id.3', 'id-1')");
        this.assertOData(this.requestOData(new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).setCount().setQuery(filterQuery)), "2", testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 and the correct count of entities with filter query when loose URL mapping work is used")
    void existingEntitiesCountWithFilterCDSUriConversionTest(VertxTestContext testContext) {
        Map<String, String> filterQuery = Map.of("$filter", "KeyPropertyString in ('id.3', 'id-1')");
        FullQualifiedName looseFQN = new FullQualifiedName("test-service1", "AllPropertiesNullable");
        this.assertOData(this.requestOData(new ODataRequest(looseFQN).setCount().setQuery(filterQuery)), "2", testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 and the correct count of entities without filter query when loose URL mapping work is used")
    void existingEntitiesCountWithoutFilterLooseUriConversionTest(VertxTestContext testContext) {
        FullQualifiedName looseFQN = new FullQualifiedName("io-neonbee-test-test-service1", "AllPropertiesNullable");
        this.assertOData(this.requestOData(new ODataRequest(looseFQN).setCount()), "6", testContext).onComplete(testContext.succeedingThenComplete());
    }
}

