/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.openapi;

import io.neonbee.config.EndpointConfig;
import io.neonbee.endpoint.openapi.AbstractOpenAPIEndpoint;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.openapi.RouterBuilder;
import io.vertx.ext.web.validation.RequestParameters;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class PetStoreEndpoint
extends AbstractOpenAPIEndpoint {
    public static final String DEFAULT_BASE_PATH = "/petstore/";
    private static final Path CONTRACT_PATH = ResourceHelper.TEST_RESOURCES.resolveRelated("petstore.json");
    private final Map<String, JsonObject> pets = new HashMap<String, JsonObject>();

    public EndpointConfig getDefaultConfig() {
        return new EndpointConfig().setType(PetStoreEndpoint.class.getName()).setBasePath(DEFAULT_BASE_PATH);
    }

    protected Future<String> getOpenAPIContractURL(Vertx vertx, JsonObject config) {
        return Future.succeededFuture((Object)CONTRACT_PATH.toString());
    }

    protected Future<Router> createRouter(Vertx vertx, RouterBuilder routerBuilder) {
        routerBuilder.operation("createPets").handler(ctx -> {
            RequestParameters params = (RequestParameters)ctx.get("requestParameters");
            String name = params.body().getJsonObject().getString("name");
            int id = this.pets.size() + 1;
            JsonObject pet = new JsonObject().put("id", (Object)id).put("name", (Object)name);
            this.pets.put(pet.getInteger("id").toString(), pet);
            ctx.response().setStatusCode(201).end();
        });
        routerBuilder.operation("listPets").handler(ctx -> {
            JsonArray response = new JsonArray();
            this.pets.values().forEach(arg_0 -> ((JsonArray)response).add(arg_0));
            ctx.response().putHeader("Content-Type", "application/json").end(response.toBuffer());
        });
        routerBuilder.operation("showPetById").handler(ctx -> {
            RequestParameters params = (RequestParameters)ctx.get("requestParameters");
            String petId = params.pathParameter("petId").getString();
            JsonObject pet = this.pets.get(petId);
            if (pet == null) {
                ctx.response().setStatusCode(404).setStatusMessage("No pet found with id: " + petId).end();
            } else {
                ctx.response().putHeader("Content-Type", "application/json");
                ctx.response().end(pet.toBuffer());
            }
        });
        return Future.succeededFuture((Object)routerBuilder.createRouter());
    }
}

