/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import com.google.common.truth.Truth;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.internal.DataContextImpl;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.junit5.VertxTestContext;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface DataResponseVerifier {
    default public <T> Future<Void> assertDataEquals(Future<T> response, T expectedValue, VertxTestContext testContext) {
        return this.assertData(response, (T r) -> Truth.assertThat((Object)r).isEqualTo(expectedValue), testContext);
    }

    default public <T> Future<Void> assertData(Future<T> response, Consumer<T> assertHandler, VertxTestContext testContext) {
        return this.assertData((DataContext ctx) -> response, (T obj, DataContext ctx) -> assertHandler.accept(obj), testContext);
    }

    default public <T> Future<Void> assertData(Function<DataContext, Future<T>> responseBuilder, BiConsumer<T, DataContext> assertHandler, VertxTestContext testContext) {
        DataContextImpl dataContext = new DataContextImpl();
        return responseBuilder.apply((DataContext)dataContext).onComplete(testContext.succeeding(arg_0 -> DataResponseVerifier.lambda$assertData$4(testContext, assertHandler, (DataContext)dataContext, arg_0))).mapEmpty();
    }

    default public Future<Void> assertDataFailure(Future<?> response, DataException exception, VertxTestContext testContext) {
        return this.assertDataFailure(response, (DataException r) -> Truth.assertThat((Throwable)r).isEqualTo((Object)exception), testContext);
    }

    default public Future<Void> assertDataFailure(Future<?> response, Consumer<DataException> assertHandler, VertxTestContext testContext) {
        return this.assertDataFailure((DataContext ctx) -> response, (DataException obj, DataContext ctx) -> assertHandler.accept((DataException)obj), testContext);
    }

    default public Future<Void> assertDataFailure(Function<DataContext, Future<?>> responseBuilder, BiConsumer<DataException, DataContext> assertHandler, VertxTestContext testContext) {
        DataContextImpl dataContext = new DataContextImpl();
        return Future.future(arg_0 -> DataResponseVerifier.lambda$assertDataFailure$11(responseBuilder, (DataContext)dataContext, testContext, assertHandler, arg_0));
    }

    private static /* synthetic */ void lambda$assertDataFailure$11(Function responseBuilder, DataContext dataContext, VertxTestContext testContext, BiConsumer assertHandler, Promise promise) {
        ((Future)responseBuilder.apply(dataContext)).onComplete(testContext.failing(failure -> {
            testContext.verify(() -> Truth.assertThat((Throwable)failure).isInstanceOf(DataException.class)).verify(() -> assertHandler.accept((DataException)failure, dataContext));
            promise.complete();
        }));
    }

    private static /* synthetic */ void lambda$assertData$4(VertxTestContext testContext, BiConsumer assertHandler, DataContext dataContext, Object response) {
        testContext.verify(() -> assertHandler.accept(response, dataContext));
    }
}

