/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import java.util.stream.Collectors;

public final class DeploymentHelper {
    public static final String NEONBEE_NAMESPACE = "neonbee";

    public static Future<String> deployVerticle(Vertx vertx, Verticle verticle) {
        return DeploymentHelper.deployVerticle(vertx, verticle, new JsonObject());
    }

    public static Future<String> deployVerticle(Vertx vertx, Verticle verticle, JsonObject verticleConfig) {
        return vertx.deployVerticle(verticle, new DeploymentOptions().setConfig(verticleConfig));
    }

    public static Future<Void> undeployVerticle(Vertx vertx, String deploymentID) {
        return vertx.undeploy(deploymentID);
    }

    public static Future<Void> undeployAllVerticlesOfClass(Vertx vertx, Class<? extends Verticle> verticleClass) {
        return CompositeFuture.all(vertx.deploymentIDs().stream().map(arg_0 -> ((VertxImpl)((VertxImpl)vertx)).getDeployment(arg_0)).filter(deployment -> deployment.getVerticles().stream().anyMatch(verticle -> verticleClass.isInstance(verticle))).map(deployment -> DeploymentHelper.undeployVerticle(vertx, deployment.deploymentID())).collect(Collectors.toList())).mapEmpty();
    }

    public static boolean isVerticleDeployed(Vertx vertx, Class<? extends Verticle> verticleToCheck) {
        return vertx.deploymentIDs().stream().flatMap(deploymentId -> ((VertxInternal)vertx).getDeployment(deploymentId).getVerticles().stream()).anyMatch(verticleToCheck::isInstance);
    }

    private DeploymentHelper() {
    }
}

