/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.function.Consumer;

public interface ODataResponseVerifier {
    default public Future<Void> assertOData(Future<HttpResponse<Buffer>> response, String expectedBody, VertxTestContext testContext) {
        return this.assertOData(response, (Buffer body) -> Truth.assertThat((String)body.toString()).isEqualTo((Object)expectedBody), testContext);
    }

    default public Future<Void> assertOData(Future<HttpResponse<Buffer>> response, JsonObject expectedBody, VertxTestContext testContext) {
        return this.assertOData(response, (Buffer body) -> Truth.assertThat((Iterable)body.toJsonObject()).isEqualTo((Object)expectedBody), testContext);
    }

    default public Future<Void> assertOData(Future<HttpResponse<Buffer>> response, Consumer<Buffer> assertHandler, VertxTestContext testContext) {
        return response.onComplete(testContext.succeeding(r -> testContext.verify(() -> {
            Truth.assertThat((Integer)r.statusCode()).isIn(Range.closed((Comparable)Integer.valueOf(200), (Comparable)Integer.valueOf(399)));
            assertHandler.accept(r.bodyAsBuffer());
        }))).mapEmpty();
    }

    default public Future<Void> assertODataProperty(Future<HttpResponse<Buffer>> response, Consumer<Object> assertHandler, VertxTestContext testContext) {
        return this.assertOData(response, (Buffer body) -> assertHandler.accept(body.toJsonObject().getValue("value")), testContext);
    }

    default public Future<Void> assertODataEntity(Future<HttpResponse<Buffer>> response, JsonObject expectedEntity, VertxTestContext testContext) {
        return this.assertODataEntity(response, (JsonObject entity) -> Truth.assertThat((Iterable)entity).isEqualTo((Object)expectedEntity), testContext);
    }

    default public Future<Void> assertODataEntity(Future<HttpResponse<Buffer>> response, Consumer<JsonObject> assertHandler, VertxTestContext testContext) {
        return this.assertOData(response, (Buffer body) -> assertHandler.accept(this.tidyMetaTags(body.toJsonObject())), testContext);
    }

    default public Future<Void> assertODataEntitySetContains(Future<HttpResponse<Buffer>> response, List<JsonObject> expectedEntities, VertxTestContext testContext) {
        return this.assertODataEntitySet(response, value -> Truth.assertThat((Iterable)value).containsAtLeastElementsIn((Iterable)expectedEntities), testContext);
    }

    default public Future<Void> assertODataEntitySetContainsExactly(Future<HttpResponse<Buffer>> response, List<JsonObject> expectedEntities, VertxTestContext testContext) {
        return this.assertODataEntitySet(response, value -> Truth.assertThat((Iterable)value).containsExactlyElementsIn((Iterable)expectedEntities), testContext);
    }

    default public Future<Void> assertODataEntitySet(Future<HttpResponse<Buffer>> response, Consumer<JsonArray> assertHandler, VertxTestContext testContext) {
        return this.assertOData(response, (Buffer value) -> {
            JsonObject entities = value.toJsonObject();
            testContext.verify(() -> assertHandler.accept(entities.containsKey("value") ? entities.getJsonArray("value") : new JsonArray().add((Object)entities)));
        }, testContext);
    }

    private JsonObject tidyMetaTags(JsonObject body) {
        body.remove("@odata.context");
        body.remove("@odata.metadataEtag");
        return body;
    }
}

