/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import io.vertx.junit5.VertxTestContext;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;

public final class ReflectionHelper {
    public static <T> T getValueOfPrivateField(Object fieldHolder, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionHelper.getValueOfPrivateField(ReflectionHelper.resolveClass(fieldHolder), fieldHolder, fieldName, false);
    }

    private static <T> T getValueOfPrivateField(Class<?> clazz, Object fieldHolder, String fieldName, boolean removeFinal) throws NoSuchFieldException, IllegalAccessException {
        Field fieldToModify = clazz.getDeclaredField(fieldName);
        fieldToModify.setAccessible(true);
        if (removeFinal) {
            ReflectionHelper.removeFinalModifier(fieldToModify);
        }
        return (T)fieldToModify.get(fieldHolder);
    }

    public static <T> T getValueOfPrivateStaticField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionHelper.getValueOfPrivateField(clazz, null, fieldName, false);
    }

    public static VertxTestContext.ExecutionBlock setValueOfPrivateField(Object objectToModify, String fieldName, Object valueToSet) throws NoSuchFieldException, IllegalAccessException {
        Object oldValue = ReflectionHelper.getValueOfPrivateField(ReflectionHelper.resolveClass(objectToModify), objectToModify, fieldName, true);
        ReflectionHelper.setValueOfPrivateField(ReflectionHelper.resolveClass(objectToModify), objectToModify, fieldName, valueToSet);
        return () -> ReflectionHelper.setValueOfPrivateField(ReflectionHelper.resolveClass(objectToModify), objectToModify, fieldName, oldValue);
    }

    private static void setValueOfPrivateField(Class<?> clazz, Object objectToModify, String fieldName, Object valueToSet) throws NoSuchFieldException, IllegalAccessException {
        Field fieldToModify = clazz.getDeclaredField(fieldName);
        fieldToModify.setAccessible(true);
        ReflectionHelper.removeFinalModifier(fieldToModify);
        fieldToModify.set(objectToModify, valueToSet);
    }

    public static VertxTestContext.ExecutionBlock setValueOfPrivateStaticField(Class<?> clazz, String fieldName, Object valueToSet) throws NoSuchFieldException, IllegalAccessException {
        Object oldValue = ReflectionHelper.getValueOfPrivateField(clazz, null, fieldName, true);
        ReflectionHelper.setValueOfPrivateField(clazz, null, fieldName, valueToSet);
        return () -> ReflectionHelper.setValueOfPrivateField(clazz, null, fieldName, oldValue);
    }

    private static Class<?> resolveClass(Object object) {
        Class<?> c = Class.class.isInstance(object) ? (Class<?>)object : object.getClass();
        return c.isAnonymousClass() ? ReflectionHelper.resolveClass(c.getSuperclass()) : c;
    }

    private static void removeFinalModifier(Field field) throws NoSuchFieldException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
        VarHandle modifiers = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
        modifiers.set(field, field.getModifiers() & 0xFFFFFFEF);
    }

    private ReflectionHelper() {
    }
}

