/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import io.neonbee.internal.helper.ThreadHelper;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ResourceHelper {
    public static final ResourceHelper TEST_RESOURCES = new ResourceHelper(Paths.get("src", "test", "resources"));
    public static final ResourceHelper MAIN_RESOURCES = new ResourceHelper(Paths.get("src", "main", "resources"));
    private final Path resourcePath;
    @Deprecated(forRemoval=true)
    public static final Path TEST_RESOURCES_PATH = Paths.get("src", "test", "resources");

    private ResourceHelper(Path resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Path resolveRelated(String filename) {
        Path packagePath = Path.of(ThreadHelper.getCallingClass().getPackage().getName().replace(".", "/"), new String[0]);
        return this.resourcePath.resolve(packagePath).resolve(filename);
    }

    public Buffer getRelated(String filename) throws IOException {
        return Buffer.buffer((byte[])Files.readAllBytes(this.resolveRelated(filename)));
    }

    public Path resolve(String relativePath) {
        return this.resolve(Path.of(relativePath, new String[0]));
    }

    public Path resolve(Path relativePath) {
        return this.resourcePath.resolve(relativePath);
    }

    public Buffer get(String relativePath) throws IOException {
        return this.get(Path.of(relativePath, new String[0]));
    }

    public Buffer get(Path relativePath) throws IOException {
        return Buffer.buffer((byte[])Files.readAllBytes(this.resourcePath.resolve(relativePath)));
    }

    @Deprecated(forRemoval=true)
    public static Path resolveTestResource(String file) {
        return ResourceHelper.resolveTestResource(Path.of(file, new String[0]));
    }

    @Deprecated(forRemoval=true)
    public static Path resolveTestResource(Path file) {
        return TEST_RESOURCES_PATH.resolve(file);
    }

    @Deprecated(forRemoval=true)
    public static Path getPackageAsPath(Package p) {
        return Path.of(p.getName().replace(".", "/"), new String[0]);
    }

    @Deprecated(forRemoval=true)
    public static Path getPackageAsPath(Class<?> clazz) {
        return ResourceHelper.getPackageAsPath(clazz.getPackage());
    }

    @Deprecated(forRemoval=true)
    public static Path getRelatedTestResource(String filename) {
        return ResourceHelper.getRelatedTestResource(Path.of(filename, new String[0]));
    }

    @Deprecated(forRemoval=true)
    public static Path getRelatedTestResource(Path file) {
        return TEST_RESOURCES_PATH.resolve(ResourceHelper.getPackageAsPath(ThreadHelper.getCallingClass())).resolve(file);
    }

    @Deprecated(forRemoval=true)
    public static Buffer getResourceAsBuffer(Path path) throws IOException {
        return Buffer.buffer((byte[])Files.readAllBytes(path));
    }

    @Deprecated(forRemoval=true)
    public static String getResourceAsString(Path path) throws IOException {
        return ResourceHelper.getResourceAsBuffer(path).toString(StandardCharsets.UTF_8);
    }
}

