/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import io.neonbee.test.helper.ReflectionHelper;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class SystemHelper {
    private static final Range<Integer> PORT_RANGE = Range.closed((Comparable)Integer.valueOf(49152), (Comparable)Integer.valueOf(65535));
    private static final Iterator<Integer> PORTS = ContiguousSet.create(PORT_RANGE, (DiscreteDomain)DiscreteDomain.integers()).iterator();

    public static int getFreePort() throws IOException {
        while (true) {
            int n;
            ServerSocket socket = new ServerSocket(PORTS.next());
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (e.getMessage().contains("Address already in use")) continue;
                        return SystemHelper.getFallbackPort();
                    }
                }
                catch (NoSuchElementException e) {
                    return SystemHelper.getFallbackPort();
                }
            }
            socket.close();
            return n;
            break;
        }
    }

    private static int getFallbackPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static void setEnvironment(Map<String, String> newEnvironment) throws Exception {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Map theEnvironment = (Map)ReflectionHelper.getValueOfPrivateField(processEnvironmentClass, "theEnvironment");
            Map theCaseInsensitiveEnvironment = (Map)ReflectionHelper.getValueOfPrivateField(processEnvironmentClass, "theCaseInsensitiveEnvironment");
            theEnvironment.clear();
            theEnvironment.putAll(newEnvironment);
            theCaseInsensitiveEnvironment.clear();
            theCaseInsensitiveEnvironment.putAll(newEnvironment);
        }
        catch (ReflectiveOperationException ex) {
            Map modifiableEnv = (Map)ReflectionHelper.getValueOfPrivateField(System.getenv(), "m");
            modifiableEnv.clear();
            modifiableEnv.putAll(newEnvironment);
        }
    }

    public static void withEnvironment(Map<String, String> newEnvironment, Runnable runnable) throws Exception {
        Map<String, String> oldEnvironment = Map.copyOf(System.getenv());
        SystemHelper.setEnvironment(newEnvironment);
        try {
            runnable.run();
        }
        finally {
            SystemHelper.setEnvironment(oldEnvironment);
        }
    }

    private SystemHelper() {
    }
}

