/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import com.sap.cds.reflect.CdsModel;
import io.neonbee.NeonBee;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.internal.verticle.ServerVerticle;
import io.neonbee.test.helper.FileSystemHelper;
import io.neonbee.test.helper.SystemHelper;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public final class WorkingDirectoryBuilder {
    public static final Path CONFIG_DIR = Path.of("config", new String[0]);
    @Deprecated
    public static final Path VERTICLES_DIR = Path.of("verticles", new String[0]);
    public static final Path MODULES_DIR = Path.of("modules", new String[0]);
    public static final Path MODELS_DIR = Path.of("models", new String[0]);
    public static final Path LOGS_DIR = Path.of("logs", new String[0]);
    private final DirType dirType;
    private final Path sourcePath;
    private final Map<Class<? extends Verticle>, DeploymentOptions> deploymentOptions = new HashMap<Class<? extends Verticle>, DeploymentOptions>();
    private final Set<Path> models = new HashSet<Path>();
    private Consumer<Path> customTask;
    private NeonBeeConfig neonbeeConfig;

    private WorkingDirectoryBuilder(DirType dirType, Path sourcePath) {
        this.dirType = dirType;
        this.sourcePath = sourcePath;
    }

    public WorkingDirectoryBuilder setDefaultServerVerticleConfig() throws IOException {
        ServerConfig config = new ServerConfig().setPort(SystemHelper.getFreePort());
        return this.setVerticleConfig(ServerVerticle.class, config.toJson());
    }

    public WorkingDirectoryBuilder setVerticleConfig(Class<? extends Verticle> verticle, JsonObject config) {
        return this.setDeploymentOptions(verticle, new DeploymentOptions().setConfig(config));
    }

    public WorkingDirectoryBuilder setDeploymentOptions(Class<? extends Verticle> verticle, DeploymentOptions options) {
        this.deploymentOptions.put(verticle, options);
        return this;
    }

    public WorkingDirectoryBuilder addModel(Path modelPath) {
        this.models.add(modelPath);
        return this;
    }

    public WorkingDirectoryBuilder setCustomTask(Consumer<Path> customTask) {
        this.customTask = customTask;
        return this;
    }

    public WorkingDirectoryBuilder setNeonBeeConfig(NeonBeeConfig neonbeeConfig) {
        this.neonbeeConfig = neonbeeConfig;
        return this;
    }

    public void build(Path workingDirRoot) throws IOException {
        switch (this.dirType) {
            case NONE: {
                break;
            }
            case EMPTY: {
                Files.createDirectories(workingDirRoot, new FileAttribute[0]);
                break;
            }
            case HOLLOW: {
                this.createHollowDirectory(workingDirRoot);
                break;
            }
            case COPY: {
                this.copyDirectory(workingDirRoot);
                break;
            }
            case STANDARD: {
                this.createHollowDirectory(workingDirRoot);
                this.setDefaultServerVerticleConfig();
                break;
            }
        }
        for (Class<? extends Verticle> verticle : this.deploymentOptions.keySet()) {
            WorkingDirectoryBuilder.writeDeploymentOptions(verticle, this.deploymentOptions.get(verticle), workingDirRoot);
        }
        for (Path modelToAdd : this.models) {
            WorkingDirectoryBuilder.copyModel(workingDirRoot.resolve(MODELS_DIR), modelToAdd);
        }
        if (this.neonbeeConfig != null) {
            Path destination = workingDirRoot.resolve(CONFIG_DIR).resolve(NeonBee.class.getName() + ".json");
            Files.writeString(destination, (CharSequence)this.neonbeeConfig.toJson().encodePrettily(), new OpenOption[0]);
        }
        Optional.ofNullable(this.customTask).ifPresent(ct -> ct.accept(workingDirRoot));
    }

    private static void copyModel(Path modelsDir, Path csnPath) throws IOException {
        String csnContent = Files.readString(csnPath);
        Path csnDestination = modelsDir.resolve(csnPath.getFileName());
        Files.writeString(csnDestination, (CharSequence)csnContent, new OpenOption[0]);
        CdsModel cdsModel = CdsModel.read((String)csnContent);
        for (Path edmxPath : EntityModelDefinition.resolveEdmxPaths((Path)csnPath, (CdsModel)cdsModel)) {
            Path edmxDestination = modelsDir.resolve(edmxPath.getFileName());
            Files.copy(edmxPath, edmxDestination, new CopyOption[0]);
        }
    }

    private void createHollowDirectory(Path workingDirRoot) throws IOException {
        for (Path dir : List.of(CONFIG_DIR, VERTICLES_DIR, MODULES_DIR, MODELS_DIR, LOGS_DIR)) {
            Files.createDirectories(workingDirRoot.resolve(dir), new FileAttribute[0]);
        }
    }

    private void copyDirectory(Path workingDirRoot) throws IOException {
        if (Files.isDirectory(this.sourcePath, new LinkOption[0])) {
            FileSystemHelper.copyDirectory(this.sourcePath, workingDirRoot);
        } else {
            FileSystemHelper.extractZipFile(this.sourcePath, workingDirRoot);
        }
    }

    public static WorkingDirectoryBuilder none() {
        return new WorkingDirectoryBuilder(DirType.NONE, null);
    }

    public static WorkingDirectoryBuilder empty() {
        return new WorkingDirectoryBuilder(DirType.EMPTY, null);
    }

    public static WorkingDirectoryBuilder hollow() {
        return new WorkingDirectoryBuilder(DirType.HOLLOW, null);
    }

    public static WorkingDirectoryBuilder copy(Path sourcePath) {
        return new WorkingDirectoryBuilder(DirType.COPY, sourcePath);
    }

    public static WorkingDirectoryBuilder standard() {
        return new WorkingDirectoryBuilder(DirType.STANDARD, null);
    }

    public static DeploymentOptions readDeploymentOptions(Class<? extends Verticle> verticle, Path workingDir) {
        try {
            Path optsPath = workingDir.resolve(CONFIG_DIR).resolve(verticle.getName() + ".json");
            return new DeploymentOptions(Buffer.buffer((byte[])Files.readAllBytes(optsPath)).toJsonObject());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeDeploymentOptions(Class<? extends Verticle> verticle, DeploymentOptions opts, Path workingDir) {
        try {
            byte[] config = opts.toJson().toBuffer().getBytes();
            Files.write(workingDir.resolve(CONFIG_DIR).resolve(verticle.getName() + ".json"), config, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum DirType {
        NONE,
        EMPTY,
        HOLLOW,
        COPY,
        STANDARD;

    }
}

