/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.listeners;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningTestReporter
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestExecutionListener.class);
    public final Set<TestIdentifier> expectedTests = Collections.synchronizedSet(new HashSet());
    public final Set<TestIdentifier> runningTests = Collections.synchronizedSet(new HashSet());
    public final Set<TestIdentifier> skippedTests = Collections.synchronizedSet(new HashSet());
    public final Set<TestIdentifier> finishedTests = Collections.synchronizedSet(new HashSet());

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.collectTests(testPlan, testPlan.getRoots());
        Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "neonbee-running-test-reporter");
            thread.setDaemon(true);
            return thread;
        }).scheduleAtFixedRate(() -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Running test overview:\n\tExpected ({}): {}\n\tRunning ({}): {}\n\tSkipped ({}): {}\n\tFinished ({}): {}", new Object[]{this.expectedTests.size(), RunningTestReporter.describeTests(this.expectedTests), this.runningTests.size(), RunningTestReporter.describeTests(this.runningTests), this.skippedTests.size(), RunningTestReporter.describeTests(this.skippedTests), this.finishedTests.size(), RunningTestReporter.describeTests(this.finishedTests)});
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private void collectTests(TestPlan testPlan, Set<TestIdentifier> identifiers) {
        identifiers.forEach(identifier -> {
            this.expectedTests.add((TestIdentifier)identifier);
            if (identifier.isContainer()) {
                this.collectTests(testPlan, testPlan.getChildren(identifier));
            }
        });
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.expectedTests.add(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.expectedTests.remove(testIdentifier)) {
            LOGGER.debug("Execution of test {} started", (Object)RunningTestReporter.describeTest(testIdentifier));
            this.runningTests.add(testIdentifier);
        } else {
            LOGGER.error("Stumbled over test {} to execute that was not expected!", (Object)RunningTestReporter.describeTest(testIdentifier));
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (this.expectedTests.remove(testIdentifier)) {
            LOGGER.debug("Execution of test {} skipped", (Object)RunningTestReporter.describeTest(testIdentifier));
            this.skippedTests.add(testIdentifier);
        } else {
            LOGGER.error("Stumbled over test {} to skip that was not expected!", (Object)RunningTestReporter.describeTest(testIdentifier));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.runningTests.remove(testIdentifier)) {
            LOGGER.debug("Execution of test {} finished", (Object)RunningTestReporter.describeTest(testIdentifier));
            this.finishedTests.add(testIdentifier);
        } else {
            LOGGER.error("Stumbled over test {} to finish that was not started!", (Object)RunningTestReporter.describeTest(testIdentifier));
        }
    }

    public static String describeTests(Collection<TestIdentifier> identifiers) {
        return RunningTestReporter.describeTests(identifiers.stream());
    }

    public static String describeTests(Stream<TestIdentifier> identifiers) {
        return identifiers.map(RunningTestReporter::describeTest).collect(Collectors.joining("; "));
    }

    public static String describeTest(TestIdentifier identifier) {
        return identifier.getDisplayName().replaceFirst("(?<=.{32}).+", "...");
    }
}

