/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.listeners;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleThreadChecker
implements TestExecutionListener {
    public static final SetMultimap<Vertx, String> VERTX_TEST_MAP = HashMultimap.create();
    static final String VERTX_THREAD_NAME_PREFIX = "vert.x-";
    private static final Logger LOGGER = LoggerFactory.getLogger(StaleThreadChecker.class);
    protected boolean parallelExecution;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.parallelExecution = Boolean.parseBoolean(System.getProperty("junit.jupiter.execution.parallel.enabled"));
        if (this.parallelExecution) {
            LOGGER.warn("Cannot check for stale threads when running JUnit in parallel execution mode");
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking for non-daemon threads after test plan execution finished");
            Thread.getAllStackTraces().keySet().stream().filter(Thread::isAlive).filter(Predicate.not(Thread::isDaemon)).forEach(thread -> LOGGER.debug("Non-daemon thread {} still is still alive", thread));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!this.parallelExecution) {
            StaleThreadChecker.checkForStaleThreads("Vert.x", VERTX_THREAD_NAME_PREFIX);
            StaleThreadChecker.checkForStaleThreads("Hazelcast", "hz.");
            StaleThreadChecker.checkForStaleThreads("WatchService", "FileSystemWatch");
        }
    }

    private static void checkForStaleThreads(String name, String namePrefix) {
        LOGGER.info("Checking for stale {} threads with '{}' prefix", (Object)name, (Object)namePrefix);
        List staleThreads = StaleThreadChecker.findStaleThreads(namePrefix).collect(Collectors.toList());
        if (!staleThreads.isEmpty() && LOGGER.isErrorEnabled()) {
            LOGGER.error("Stale {} thread(s) detected!! Not closing the thread {} could result in the test runner not signaling completion", (Object)name, staleThreads.get(0));
        }
    }

    protected static Stream<Thread> findStaleThreads(String namePrefix) {
        return Thread.getAllStackTraces().keySet().stream().filter(Thread::isAlive).filter(thread -> thread.getName().startsWith(namePrefix));
    }
}

