/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Hash;
import io.neow3j.utils.Numeric;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HashTest {
    @Test
    public void testSha3() {
        byte[] input = new byte[]{Numeric.asByte((int)6, (int)8), Numeric.asByte((int)6, (int)5), Numeric.asByte((int)6, (int)12), Numeric.asByte((int)6, (int)12), Numeric.asByte((int)6, (int)15), Numeric.asByte((int)2, (int)0), Numeric.asByte((int)7, (int)7), Numeric.asByte((int)6, (int)15), Numeric.asByte((int)7, (int)2), Numeric.asByte((int)6, (int)12), Numeric.asByte((int)6, (int)4)};
        byte[] expected = new byte[]{Numeric.asByte((int)4, (int)7), Numeric.asByte((int)1, (int)7), Numeric.asByte((int)3, (int)2), Numeric.asByte((int)8, (int)5), Numeric.asByte((int)10, (int)8), Numeric.asByte((int)13, (int)7), Numeric.asByte((int)3, (int)4), Numeric.asByte((int)1, (int)14), Numeric.asByte((int)5, (int)14), Numeric.asByte((int)9, (int)7), Numeric.asByte((int)2, (int)15), Numeric.asByte((int)12, (int)6), Numeric.asByte((int)7, (int)7), Numeric.asByte((int)2, (int)8), Numeric.asByte((int)6, (int)3), Numeric.asByte((int)8, (int)4), Numeric.asByte((int)15, (int)8), Numeric.asByte((int)0, (int)2), Numeric.asByte((int)15, (int)8), Numeric.asByte((int)14, (int)15), Numeric.asByte((int)4, (int)2), Numeric.asByte((int)10, (int)5), Numeric.asByte((int)14, (int)12), Numeric.asByte((int)5, (int)15), Numeric.asByte((int)0, (int)3), Numeric.asByte((int)11, (int)11), Numeric.asByte((int)15, (int)10), Numeric.asByte((int)2, (int)5), Numeric.asByte((int)4, (int)12), Numeric.asByte((int)11, (int)0), Numeric.asByte((int)1, (int)15), Numeric.asByte((int)10, (int)13)};
        byte[] result = Hash.sha3((byte[])input);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testSha3HashHex() {
        Assert.assertThat((Object)Hash.sha3((String)""), (Matcher)CoreMatchers.is((Object)"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470"));
        Assert.assertThat((Object)Hash.sha3((String)"68656c6c6f20776f726c64"), (Matcher)CoreMatchers.is((Object)"0x47173285a8d7341e5e972fc677286384f802f8ef42a5ec5f03bbfa254cb01fad"));
    }

    @Test
    public void testSha3String() {
        Assert.assertThat((Object)Hash.sha3String((String)""), (Matcher)CoreMatchers.is((Object)"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470"));
        Assert.assertThat((Object)Hash.sha3String((String)"EVWithdraw(address,uint256,bytes32)"), (Matcher)CoreMatchers.is((Object)"0x953d0c27f84a9649b0e121099ffa9aeb7ed83e65eaed41d3627f895790c72d41"));
    }

    @Test
    public void testByte() {
        Assert.assertThat((Object)Numeric.asByte((int)0, (int)0), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)Numeric.asByte((int)1, (int)0), (Matcher)CoreMatchers.is((Object)16));
        Assert.assertThat((Object)Numeric.asByte((int)15, (int)15), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)Numeric.asByte((int)12, (int)5), (Matcher)CoreMatchers.is((Object)-59));
    }

    @Test
    public void testRipeMD160() {
        String expected = "c5d570cb5b85319dbafc0385b998fd98eb62295e";
        byte[] bytesToHash = "Hello World.".getBytes();
        byte[] result = Hash.ripemd160((byte[])bytesToHash);
        Assert.assertThat((Object)Numeric.toHexStringNoPrefix((byte[])result), (Matcher)CoreMatchers.is((Object)"c5d570cb5b85319dbafc0385b998fd98eb62295e"));
    }

    @Test
    public void testRipeMD160String() {
        String expected = "0xc5d570cb5b85319dbafc0385b998fd98eb62295e";
        String hexStringToHash = Numeric.toHexString((byte[])"Hello World.".getBytes());
        String result = Hash.ripemd160((String)hexStringToHash);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0xc5d570cb5b85319dbafc0385b998fd98eb62295e"));
    }
}

