/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.io;

import io.neow3j.io.BinaryWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinaryWriterTest {
    private ByteArrayOutputStream outStream;
    private BinaryWriter writer;

    @Before
    public void setUp() {
        this.outStream = new ByteArrayOutputStream();
        this.writer = new BinaryWriter((OutputStream)this.outStream);
    }

    @Test
    public void writeUInt32() throws IOException {
        long uint = (long)Math.pow(2.0, 32.0) - 1L;
        this.writer.writeUInt32(uint);
        this.assertAndResetStreamContents(new byte[]{-1, -1, -1, -1});
        uint = 0L;
        this.writer.writeUInt32(uint);
        this.assertAndResetStreamContents(new byte[]{0, 0, 0, 0});
        uint = 12345L;
        this.writer.writeUInt32(uint);
        this.assertAndResetStreamContents(new byte[]{57, 48, 0, 0});
    }

    @Test
    public void failWritingUInt32NotInRange() throws IOException {
        Long uint2;
        try {
            uint2 = (long)Math.pow(2.0, 32.0);
            this.writer.writeUInt32(uint2.longValue());
            Assert.fail();
        }
        catch (IllegalArgumentException uint2) {
            // empty catch block
        }
        try {
            uint2 = -1L;
            this.writer.writeUInt32(uint2.longValue());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void writeInt64() throws IOException {
        long l = Long.MAX_VALUE;
        this.writer.writeInt64(l);
        this.assertAndResetStreamContents(new byte[]{-1, -1, -1, -1, -1, -1, -1, 127});
        l = Long.MIN_VALUE;
        this.writer.writeInt64(l);
        this.assertAndResetStreamContents(new byte[]{0, 0, 0, 0, 0, 0, 0, -128});
        l = 0L;
        this.writer.writeInt64(l);
        this.assertAndResetStreamContents(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        l = 1234567890L;
        this.writer.writeInt64(l);
        this.assertAndResetStreamContents(new byte[]{-46, 2, -106, 73, 0, 0, 0, 0});
    }

    @Test
    public void writeUInt16() throws IOException {
        int uint = (int)Math.pow(2.0, 16.0) - 1;
        this.writer.writeUInt16(uint);
        this.assertAndResetStreamContents(new byte[]{-1, -1});
        uint = 0;
        this.writer.writeUInt16(uint);
        this.assertAndResetStreamContents(new byte[]{0, 0});
        uint = 12345;
        this.writer.writeUInt16(uint);
        this.assertAndResetStreamContents(new byte[]{57, 48});
    }

    @Test
    public void failWritingUInt16NotInRange() throws IOException {
        int uint2;
        try {
            uint2 = (int)Math.pow(2.0, 16.0);
            this.writer.writeUInt16(uint2);
            Assert.fail();
        }
        catch (IllegalArgumentException uint2) {
            // empty catch block
        }
        try {
            uint2 = -1;
            this.writer.writeUInt16(uint2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void writeVarInt() throws IOException {
        this.writer.writeVarInt(0L);
        this.assertAndResetStreamContents(new byte[]{0});
        this.writer.writeVarInt(252L);
        this.assertAndResetStreamContents(new byte[]{-4});
        this.writer.writeVarInt(253L);
        this.assertAndResetStreamContents(new byte[]{-3, -3, 0});
        this.writer.writeVarInt(254L);
        this.assertAndResetStreamContents(new byte[]{-3, -2, 0});
        this.writer.writeVarInt(65534L);
        this.assertAndResetStreamContents(new byte[]{-3, -2, -1});
        this.writer.writeVarInt(65535L);
        this.assertAndResetStreamContents(new byte[]{-3, -1, -1});
        this.writer.writeVarInt(65536L);
        this.assertAndResetStreamContents(new byte[]{-2, 0, 0, 1, 0});
        this.writer.writeVarInt(0xFFFFFFFEL);
        this.assertAndResetStreamContents(new byte[]{-2, -2, -1, -1, -1});
        this.writer.writeVarInt(0xFFFFFFFFL);
        this.assertAndResetStreamContents(new byte[]{-2, -1, -1, -1, -1});
        this.writer.writeVarInt(0x100000000L);
        this.assertAndResetStreamContents(new byte[]{-1, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void failWriteVarInt() throws IOException {
        this.writer.writeVarInt(-1L);
    }

    private void assertAndResetStreamContents(byte[] expected) throws IOException {
        this.writer.flush();
        byte[] actual = this.outStream.toByteArray();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        this.outStream.reset();
    }
}

