/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.crypto.Hash;
import io.neow3j.model.NeoConfig;
import io.neow3j.utils.AddressUtils;
import io.neow3j.utils.Numeric;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class AddressUtilsTest {
    @Test
    public void scriptHashToAddress() {
        NeoConfig.setAddressVersion((byte)23);
        String script = "2102208aea0068c429a03316e37be0e3e8e21e6cda5442df4c5914a19b3a9b6de37568747476aa";
        byte[] scriptHash = Hash.sha256AndThenRipemd160((byte[])Numeric.hexStringToByteArray((String)script));
        String address = AddressUtils.scriptHashToAddress((byte[])scriptHash);
        String expectedAddress = "Aa63RMYRWHPRcrZNzUnq5SNrPqoV866Spu";
        Assert.assertThat((Object)address, (Matcher)Is.is((Object)expectedAddress));
    }

    @Test
    public void scriptHashToAddressWithAddressVersion() {
        String script = "21030529d1296dc2af1f77d8344138a77748599b69599af7ae6be57812a4ec3fa33968747476aa";
        byte[] scriptHash = Hash.sha256AndThenRipemd160((byte[])Numeric.hexStringToByteArray((String)script));
        System.out.println(Numeric.toHexString((byte[])scriptHash));
        String address = AddressUtils.scriptHashToAddress((byte[])scriptHash);
        String expectedAddress = "PRivaTenetyWuqK7Gj7Vd747d77ssYeDhL";
        Assert.assertThat((Object)address, (Matcher)Is.is((Object)expectedAddress));
    }

    @Test
    public void addressToScriptHash() {
        byte[] scriptHash = AddressUtils.addressToScriptHash((String)"Aa63RMYRWHPRcrZNzUnq5SNrPqoV866Spu");
        String script = "2102208aea0068c429a03316e37be0e3e8e21e6cda5442df4c5914a19b3a9b6de37568747476aa";
        byte[] expected = Hash.sha256AndThenRipemd160((byte[])Numeric.hexStringToByteArray((String)script));
        Assert.assertArrayEquals((byte[])scriptHash, (byte[])expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addressToScriptHash_InvalidAddress() {
        AddressUtils.addressToScriptHash((String)"Aa63RMYRWHPRcrZNzUnq5SNrPqoV866Sp");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToScriptHashLargerThan25Chars() {
        AddressUtils.addressToScriptHash((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8yyyy");
    }

    @Test
    public void testScriptHashToAddress() {
        byte[] scriptHash = Numeric.hexStringToByteArray((String)"d336d7eb9975a29b2404fdb28185e277a4b299bc");
        String address = "Ab2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU";
        Assert.assertThat((Object)AddressUtils.scriptHashToAddress((byte[])scriptHash), (Matcher)Is.is((Object)address));
    }

    @Test
    public void testScriptHashToAddressWithVersion() {
        NeoConfig.setAddressVersion((byte)55);
        byte[] scriptHash = Numeric.hexStringToByteArray((String)"bbf14c0d508108e56402116aede9942a064f7dc6");
        String address = "PRivaTenetyWuqK7Gj7Vd747d77ssYeDhL";
        Assert.assertThat((Object)AddressUtils.scriptHashToAddress((byte[])scriptHash), (Matcher)Is.is((Object)address));
    }

    @Test
    public void testIsValidAddress() {
        Assert.assertTrue((boolean)AddressUtils.isValidAddress((String)"Ab2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU"));
        Assert.assertTrue((boolean)AddressUtils.isValidAddress((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y"));
        Assert.assertFalse((boolean)AddressUtils.isValidAddress((String)""));
        Assert.assertFalse((boolean)AddressUtils.isValidAddress((String)"0"));
        Assert.assertFalse((boolean)AddressUtils.isValidAddress((String)"b2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU"));
        Assert.assertFalse((boolean)AddressUtils.isValidAddress((String)"AAb2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU"));
        try {
            AddressUtils.isValidAddress(null);
        }
        catch (NullPointerException e) {
            return;
        }
        TestCase.fail();
    }
}

