/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.json;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.CorruptedFrameException;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.util.internal.ObjectUtil;

public class JsonObjectDecoder
extends ByteToMessageDecoder {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private final int maxObjectLength;
    private final boolean streamArrayElements;
    private int openBraces;
    private int idx;
    private int lastReaderOffset;
    private int state;
    private boolean insideString;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    public JsonObjectDecoder(int maxObjectLength) {
        this(maxObjectLength, false);
    }

    public JsonObjectDecoder(boolean streamArrayElements) {
        this(0x100000, streamArrayElements);
    }

    public JsonObjectDecoder(int maxObjectLength, boolean streamArrayElements) {
        this.maxObjectLength = ObjectUtil.checkPositive((int)maxObjectLength, (String)"maxObjectLength");
        this.streamArrayElements = streamArrayElements;
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) {
        int idx;
        int wrtOffset;
        if (this.state == -1) {
            in.skipReadableBytes(in.readableBytes());
            return;
        }
        if (this.idx > in.readerOffset() && this.lastReaderOffset != in.readerOffset()) {
            this.idx = in.readerOffset() + this.idx - this.lastReaderOffset;
        }
        if ((wrtOffset = in.writerOffset()) > this.maxObjectLength) {
            in.skipReadableBytes(in.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + wrtOffset + " bytes discarded");
        }
        for (idx = this.idx; idx < wrtOffset; ++idx) {
            byte c = in.getByte(idx);
            if (this.state == 1) {
                int newWrtOffset;
                this.decodeByte(c, in, idx);
                if (this.openBraces != 0) continue;
                Buffer json = this.extractObject(ctx, in, in.readerOffset(), idx + 1 - in.readerOffset());
                if (json != null) {
                    ctx.fireChannelRead((Object)json);
                }
                if (wrtOffset > (newWrtOffset = in.writerOffset())) {
                    idx = -1;
                    wrtOffset = newWrtOffset;
                } else {
                    in.readerOffset(idx + 1);
                }
                this.reset();
                continue;
            }
            if (this.state == 2) {
                int newWrtOffset;
                int idxNoSpaces;
                this.decodeByte(c, in, idx);
                if (this.insideString || (this.openBraces != 1 || c != 44) && (this.openBraces != 0 || c != 93)) continue;
                int i = in.readerOffset();
                while (Character.isWhitespace(in.getByte(i))) {
                    in.skipReadableBytes(1);
                    ++i;
                }
                for (idxNoSpaces = idx - 1; idxNoSpaces >= in.readerOffset() && Character.isWhitespace(in.getByte(idxNoSpaces)); --idxNoSpaces) {
                }
                Buffer json = this.extractObject(ctx, in, in.readerOffset(), idxNoSpaces + 1 - in.readerOffset());
                if (json != null) {
                    ctx.fireChannelRead((Object)json);
                }
                if (wrtOffset > (newWrtOffset = in.writerOffset())) {
                    idx = idx - idxNoSpaces - 1;
                    in.readerOffset(idx + 1);
                    wrtOffset = newWrtOffset;
                } else {
                    in.readerOffset(idx + 1);
                }
                if (c != 93) continue;
                this.reset();
                continue;
            }
            if (c == 123 || c == 91) {
                this.initDecoding(c);
                if (this.state != 2) continue;
                in.skipReadableBytes(1);
                continue;
            }
            if (Character.isWhitespace(c)) {
                in.skipReadableBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + idx + ": " + BufferUtil.hexDump((Buffer)in));
        }
        this.idx = in.readableBytes() == 0 ? 0 : idx;
        this.lastReaderOffset = in.readerOffset();
    }

    protected Buffer extractObject(ChannelHandlerContext ctx, Buffer buffer, int index, int length) {
        return buffer.readSplit(length);
    }

    private void decodeByte(byte c, Buffer in, int idx) {
        if (!(c != 123 && c != 91 || this.insideString)) {
            ++this.openBraces;
        } else if (!(c != 125 && c != 93 || this.insideString)) {
            --this.openBraces;
        } else if (c == 34) {
            if (!this.insideString) {
                this.insideString = true;
            } else {
                int backslashCount = 0;
                --idx;
                while (idx >= 0 && in.getByte(idx) == 92) {
                    ++backslashCount;
                    --idx;
                }
                if (backslashCount % 2 == 0) {
                    this.insideString = false;
                }
            }
        }
    }

    private void initDecoding(byte openingBrace) {
        this.openBraces = 1;
        this.state = openingBrace == 91 && this.streamArrayElements ? 2 : 1;
    }

    private void reset() {
        this.insideString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

