/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.marshalling;

import io.netty5.buffer.Buffer;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;

class ChannelBufferByteInput
implements ByteInput {
    private final Buffer buffer;

    ChannelBufferByteInput(Buffer buffer) {
        this.buffer = buffer;
    }

    public void close() throws IOException {
    }

    public int available() {
        return this.buffer.readableBytes();
    }

    public int read() {
        if (this.buffer.readableBytes() > 0) {
            return this.buffer.readByte() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] array) {
        return this.read(array, 0, array.length);
    }

    public int read(byte[] dst, int dstIndex, int length) {
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        length = Math.min(available, length);
        this.buffer.readBytes(dst, dstIndex, length);
        return length;
    }

    public long skip(long bytes) {
        int readable = this.buffer.readableBytes();
        if ((long)readable < bytes) {
            bytes = readable;
        }
        this.buffer.readerOffset((int)((long)this.buffer.readerOffset() + bytes));
        return bytes;
    }
}

