/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.marshalling;

import io.netty.contrib.handler.codec.marshalling.ChannelBufferByteInput;
import io.netty.contrib.handler.codec.marshalling.UnmarshallerProvider;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.LengthFieldBasedFrameDecoder;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

public class MarshallingDecoder
extends LengthFieldBasedFrameDecoder {
    private final UnmarshallerProvider provider;

    public MarshallingDecoder(UnmarshallerProvider provider) {
        this(provider, 0x100000);
    }

    public MarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.provider = provider;
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Buffer frame = (Buffer)super.decode0(ctx, in);
        if (frame == null) {
            return null;
        }
        try (Buffer buffer = frame;){
            Object object;
            block13: {
                Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
                try {
                    ChannelBufferByteInput input = new ChannelBufferByteInput(frame);
                    unmarshaller.start((ByteInput)input);
                    Object obj = unmarshaller.readObject();
                    unmarshaller.finish();
                    object = obj;
                    if (unmarshaller == null) break block13;
                }
                catch (Throwable throwable) {
                    if (unmarshaller != null) {
                        try {
                            unmarshaller.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                unmarshaller.close();
            }
            return object;
        }
    }
}

