/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.marshalling;

import io.netty.contrib.handler.codec.marshalling.ChannelBufferByteOutput;
import io.netty.contrib.handler.codec.marshalling.MarshallerProvider;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider provider) {
        this.provider = provider;
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Object o) {
        return ctx.bufferAllocator().allocate(256);
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, Buffer out) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        int lengthPos = out.writerOffset();
        out.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput output = new ChannelBufferByteOutput(out);
        marshaller.start((ByteOutput)output);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        out.setInt(lengthPos, out.writerOffset() - lengthPos - 4);
    }

    public boolean isSharable() {
        return true;
    }
}

