/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.protobuf;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageDecoder;
import java.util.Objects;

public class ProtobufDecoder
extends MessageToMessageDecoder<Buffer> {
    private static final boolean HAS_PARSER;
    private final MessageLite prototype;
    private final ExtensionRegistryLite extensionRegistry;

    public ProtobufDecoder(MessageLite prototype) {
        this(prototype, (ExtensionRegistry)null);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistry extensionRegistry) {
        this(prototype, (ExtensionRegistryLite)extensionRegistry);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistryLite extensionRegistry) {
        Objects.requireNonNull(prototype, "prototype");
        this.prototype = prototype.getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    protected void decode(ChannelHandlerContext ctx, Buffer msg) throws Exception {
        int length = msg.readableBytes();
        byte[] array = new byte[length];
        msg.copyInto(msg.readerOffset(), array, 0, length);
        int offset = 0;
        if (this.extensionRegistry == null) {
            if (HAS_PARSER) {
                ctx.fireChannelRead(this.prototype.getParserForType().parseFrom(array, offset, length));
            } else {
                ctx.fireChannelRead((Object)this.prototype.newBuilderForType().mergeFrom(array, offset, length).build());
            }
        } else if (HAS_PARSER) {
            ctx.fireChannelRead(this.prototype.getParserForType().parseFrom(array, offset, length, this.extensionRegistry));
        } else {
            ctx.fireChannelRead((Object)this.prototype.newBuilderForType().mergeFrom(array, offset, length, this.extensionRegistry).build());
        }
    }

    public boolean isSharable() {
        return true;
    }

    static {
        boolean hasParser = false;
        try {
            MessageLite.class.getDeclaredMethod("getParserForType", new Class[0]);
            hasParser = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_PARSER = hasParser;
    }
}

