/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.protobuf;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.CorruptedFrameException;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    private static int readRawVarint32(Buffer buffer) {
        if (buffer.readableBytes() == 0) {
            return 0;
        }
        int readerIndex = buffer.readerOffset();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (buffer.readableBytes() == 0) {
            buffer.readerOffset(readerIndex);
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if (buffer.readableBytes() == 0) {
                buffer.readerOffset(readerIndex);
                return 0;
            }
            tmp = buffer.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if (buffer.readableBytes() == 0) {
                    buffer.readerOffset(readerIndex);
                    return 0;
                }
                tmp = buffer.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    if (buffer.readableBytes() == 0) {
                        buffer.readerOffset(readerIndex);
                        return 0;
                    }
                    tmp = buffer.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) {
        int readerIndex = in.readerOffset();
        int preIndex = in.readerOffset();
        int length = ProtobufVarint32FrameDecoder.readRawVarint32(in);
        if (preIndex == in.readerOffset()) {
            return;
        }
        if (length < 0) {
            throw new CorruptedFrameException("negative length: " + length);
        }
        if (in.readableBytes() < length) {
            in.readerOffset(readerIndex);
        } else {
            ctx.fireChannelRead((Object)in.readSplit(length));
        }
    }
}

