/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.protobuf;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;

public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<Buffer> {
    static void writeRawVarint32(Buffer out, int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                out.writeByte((byte)value);
                return;
            }
            out.writeByte((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Buffer buffer) {
        return ctx.bufferAllocator().allocate(0);
    }

    protected void encode(ChannelHandlerContext ctx, Buffer msg, Buffer out) {
        int bodyLen = msg.readableBytes();
        int headerLen = ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size(bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        ProtobufVarint32LengthFieldPrepender.writeRawVarint32(out, bodyLen);
        out.writeBytes(msg);
    }

    public boolean isSharable() {
        return true;
    }
}

