/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.serialization;

import io.netty.contrib.handler.codec.serialization.CachingClassResolver;
import io.netty.contrib.handler.codec.serialization.ClassLoaderClassResolver;
import io.netty.contrib.handler.codec.serialization.ClassResolver;
import io.netty.contrib.handler.codec.serialization.SoftReferenceMap;
import io.netty.contrib.handler.codec.serialization.WeakReferenceMap;
import io.netty5.util.internal.PlatformDependent;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassResolvers {
    private ClassResolvers() {
    }

    public static ClassResolver cacheDisabled(ClassLoader classLoader) {
        return new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader));
    }

    public static ClassResolver weakCachingResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new WeakReferenceMap(new HashMap()));
    }

    public static ClassResolver softCachingResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new SoftReferenceMap(new HashMap()));
    }

    public static ClassResolver weakCachingConcurrentResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new WeakReferenceMap(new ConcurrentHashMap()));
    }

    public static ClassResolver softCachingConcurrentResolver(ClassLoader classLoader) {
        return new CachingClassResolver(new ClassLoaderClassResolver(ClassResolvers.defaultClassLoader(classLoader)), new SoftReferenceMap(new ConcurrentHashMap()));
    }

    static ClassLoader defaultClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader contextClassLoader = PlatformDependent.getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return PlatformDependent.getClassLoader(ClassResolvers.class);
    }
}

