/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.serialization;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferOutputStream;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import io.netty5.util.internal.ObjectUtil;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Serializable serializable) {
        return ctx.bufferAllocator().allocate(256);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        this.resetInterval = ObjectUtil.checkPositiveOrZero((int)resetInterval, (String)"resetInterval");
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    protected void encode(ChannelHandlerContext ctx, Serializable msg, Buffer out) throws Exception {
        try (ObjectOutputStream oos = this.newObjectOutputStream((OutputStream)new BufferOutputStream(out));){
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    oos.reset();
                }
            }
            oos.writeObject(msg);
            oos.flush();
        }
    }
}

