/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.serialization;

import io.netty.contrib.handler.codec.serialization.ClassResolver;
import io.netty.contrib.handler.codec.serialization.CompactObjectInputStream;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferInputStream;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.InputStream;

public class ObjectDecoder
extends LengthFieldBasedFrameDecoder {
    private final ClassResolver classResolver;

    public ObjectDecoder(ClassResolver classResolver) {
        this(0x100000, classResolver);
    }

    public ObjectDecoder(int maxObjectSize, ClassResolver classResolver) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.classResolver = classResolver;
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Buffer frame = (Buffer)super.decode0(ctx, in);
        if (frame == null) {
            return null;
        }
        try (CompactObjectInputStream ois = new CompactObjectInputStream((InputStream)new BufferInputStream(frame.send()), this.classResolver);){
            Object object = ois.readObject();
            return object;
        }
    }
}

